<?php 
session_start();

if (!isset($_login_page) || !$_login_page) {
    
    if (!isset($_SESSION['username'])) {
        header("Location: " . $_main_root . "index.php");
        exit();
    }
}

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="<?php echo ($_main_root . 'style/bootstrap-5.3.0/css/bootstrap.min.css'); ?>">
    <link rel="stylesheet" href="<?php echo ($_main_root . 'style/bootstrap-icons-1.10.5/font/bootstrap-icons.css'); ?>">
    <link rel="stylesheet" href="<?php echo ($_main_root . 'style/DataTables/datatables.min.css'); ?>">
    <link rel="stylesheet" href="<?php echo ($_main_root . 'style/custom/style.css'); ?>">
    <title>
        <?php echo ($_page_title); ?>
    </title>
</head>

<body>
    <?php
    include($_main_root .'config/config.php');
    $_payment = false;
    $_profile = false;
    $_user = false;
    
    if (isset($_SESSION['username'])) {
        
        setcookie('desig', $_SESSION['desig'], time() + 3600, '/');

        $_userProfileImage = $_main_root . "img/user/" . $_SESSION["username"] . '.jpg';
        if(!file_exists($_userProfileImage)){
            $_userProfileImage = $_main_root . "img/user/default_user.png";
        }
    ?>
        <nav class="navbar sticky-top navbar-expand-md navbar-dark bg-dark mb-4">
            <div class="container">
                <a class="navbar-brand" href="dashboard.php">
                    <img src="<?php echo ($_main_root . 'img/logo.png'); ?>" width="150px" alt="" srcset="">
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse menu_custom" id="navbarNav">
                    <ul class="navbar-nav ms-auto">
                        <li class="nav-item">
                            <a class="nav-link" href="dashboard.php">DASHBOARD</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="event_list_due.php">PENDING LIST</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="event_list_pay_complete.php">COMPLETE LIST</a>
                        </li>

                        <?php if(Permission(2)){?>
                            
                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" data-bs-toggle="dropdown" href="#" role="button" aria-expanded="false">
                                    EMPLOYEE
                                </a>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="employee.php">ADD EMPLOYEE / LIST</a></li>
                                    <li><a class="dropdown-item" href="emp_payment.php">PAYMENT</a></li>
                                </ul>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="report.php">REPORT</a>
                            </li>

                        </li>

                        <?php }?>

                        <?php if(Permission()){?>
                            <li class="nav-item">
                                <a class="nav-link" href="user_manage.php">USERS</a>
                            </li>
                        <?php }?>

                        <li class="nav-item dropdown ms-md-4">
                            <a class="nav-link dropdown-toggle" data-bs-toggle="dropdown" href="#" role="button" aria-expanded="false">
                                <img src="<?php echo $_userProfileImage; ?>" alt="" width="30" height="30" class="rounded-circle">
                                <!-- <i class="bi bi-person-circle me-1"></i>  -->
                                <?php echo $_SESSION['username'] ?>
                            </a>
                            <ul class="dropdown-menu">
                                <li> 
                                    <a class="dropdown-item" href="profile.php"><i class="bi bi-people me-3"></i> Profile</a>
                                </li>
                                <li><hr class="dropdown-divider"></li>
                                <li class="text-center">
                                    <a class="dropdown-item" href="<?php echo ($_main_root . 'db/do_logout.php'); ?>">LOGOUT<i class="bi bi-box-arrow-right ms-2"></i></a>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>
    <?php
    }
    ?>