<?php
$_page_title = "Pending Event List";
$_main_root = '../';
include("header.php");
$_payment = true;
?>

<!-- ============= Pending event list start ================ -->

<!-- modal -->
<div id="paymentModalDiv"></div>

<div class="container container-fluid">
    <div class="my-4">
        <h2 style="color:var(--s-text-color);" class="text-center">PENDING EVENTS LIST</h2>
    </div>
    <div class="row justify-content-center my-4">
        <div class="table-responsive-lg">

            <table id="dataTable" class="table table-sm table-dark table-hover table-bordered" style="width: 100%;">
                <thead style="color:var(--s-text-color);" class="mt-3">
                    <th style="width: 84px;">Booking Date</th>
                    <th>Client Name</th>
                    <th>Phone</th>
                    <th style="width: 50px;">Event Type</th>
                    <th style="width: 150px;">Package Type</th>
                    <th style="width: 50px;">Package Amount</th>
                    <th style="width: 30px;">Disc</th>
                    <th style="width: 50px;">Due Amount</th>
                    <th style="width: 84px;">Event Date</th>
                    <th style="width: 60px;">Event Time</th>
                    <th style="width: 50px;">Action</th>
                </thead>
                <tbody>
                </tbody>
            </table>

        </div>
    </div>
</div>

<!-- ============= Pending event list end ================ -->

<?php include("footer.php"); ?>
<script>
    $(document).ready(function() {
        table = $('#dataTable').DataTable({
            "order": [],
            ajax: {
                url: 'js/json.php',
                dataSrc: 'eventList'
            },
            columns: [{
                data: null,
                    render: function (data) { 
                        return sDate(data['booking_date_time']);
                     }
                },
                {
                    data: 'client_name'
                },
                {
                    data: 'phone'
                },
                {
                    data: 'event_type'
                },
                {
                    data: null,
                    render: function (data, type, row) { 
                        var packageName=data['package_type'];
                        return packageName.substring(0, packageName.length-2);
                    }
                },
                {
                    data: 'package_amount'
                },
                {
                    data: 'discount'
                },
                {
                    data: 'due_amount'
                },
                {
                    data: null,
                    render: function (data) { 
                        return sDate(data['event_date_time']);
                     }
                },
                {
                    data: null,
                    render: function (data) { 
                        return sTime(data['event_date_time']);
                     }
                },
                {
                    data: null,
                    render: function(data, type, row) {
                        var btn = '<div class="btn-group">';
                        btn += '<button type="button" name="payment" class="btn btn-sm action-btn" onclick="PaymentForm(' + row.id + ')">Payment</button>';
                        btn += '</div>';
                        return btn;
                    }
                }
            ]
        });
    });
</script>