var InvoicePrefixEmpPay = '#E-INV-';
var daysNameShort = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
var daysNameFull = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
var monthsNameShort = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
var monthsNameFull = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];

$.extend(true, $.fn.dataTable.defaults, {
    oLanguage: {
        sLengthMenu: "Show _MENU_ Entries",
    },
    aLengthMenu: [
        [10, 25, 50, 100, -1],
        [10, 25, 50, 100, "All"],
    ],
    iDisplayLength: 25,
    order: [],
    // bSort: false,
});

var user_roles = {
    1: 'Super Admin',
    2: 'Admin',
    3: 'User'
};

var user_status = {
    0: 'DE-ACTIVE',
    1: 'ACTIVE'
};

function getCookie(name) {
    var match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
    if (match) return match[2];
}

function Permission(roleRequired = 1) {
    var userRole = getCookie('desig');

    if (userRole && (userRole === roleRequired.toString() || userRole === '1')) {
        return true;
    }

    return false;
}

function sDate(date, standardFormat = false, daysName = false) {
    var formattedDate = new Date(date);

    var day = formattedDate.getDate().toString().padStart(2, '0');
    var monthNumber = (formattedDate.getMonth() + 1).toString().padStart(2, '0');

    var dayName = daysNameShort[formattedDate.getDay()];
    var monthName = monthsNameShort[formattedDate.getMonth()];
    var year = formattedDate.getFullYear();

    if (daysName) {
        return `${dayName}, ${day}-${monthName}-${year}`;
    } else {
        return (standardFormat) ? `${year}-${monthNumber}-${day}` : `${day}-${monthName}-${year}`;
    }
}

function sTime(date, use12HourFormat = true, hideSecond = true) {
    var formattedDate = new Date(date);

    var hours = formattedDate.getHours();
    var minutes = formattedDate.getMinutes().toString().padStart(2, '0');
    var seconds = formattedDate.getSeconds().toString().padStart(2, '0');

    var period = '';
    if (use12HourFormat) {
        period = hours >= 12 ? ' PM' : ' AM';
        hours = hours % 12 || 12;
        hours = hours.toString().padStart(2, '0');
    } else {
        hours = hours.toString().padStart(2, '0');
    }

    return `${hours}:${minutes}${hideSecond ? '' : ':' + seconds}${period}`;
}

function CheckPrint(tableId = "dataTable") {
    var table = $('#' + tableId).DataTable();

    if (table.rows().count() === 0) {
        swal("No data available to print", {
            icon: "warning",
        });
        return false;
    }

    return true;
}