<?php
// define('BASE_URL', 'cmsv.shakikul.com/');
define('BASE_URL', 'http://192.168.0.240/cmsv/');
//define('BASE_URL', 'http://192.168.1.107/bas/');

define('IMAGE_EXTENSION', '.jpg');
define('EMP_PHOTO_URL', 'img/emp/');
define('EMP_DEFAULT_PHOTO', 'emp_default.jpeg');
define('EMP_DEFAULT_PHOTO_URL', 'img/' . EMP_DEFAULT_PHOTO);

define('SELECT_ONE', '<option value="">--- select ---</option>');

define("CURRENT_DATE", date("Y-m-d H:i:s"));


function EmpImageSet($img)
{
    $empImgSrc = "";

    $empImgPath = EMP_PHOTO_URL . $img;
    if (file_exists($empImgPath)) {
        $empImgSrc = $empImgPath;
    } else {
        $empImgSrc = EMP_DEFAULT_PHOTO_URL;
    }

    echo $empImgSrc;
}

function sDate($date, $daysName = false, $returnBlank = true)
{
    if ($returnBlank && empty($date)) {
        return "";
    }

    $daysOfWeek = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];
    $monthsOfYear = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];

    $formattedDate = new DateTime($date);

    $dayOfWeek = $daysOfWeek[$formattedDate->format('w')];
    $day = $formattedDate->format('d');
    $month = $monthsOfYear[$formattedDate->format('n') - 1];
    $year = $formattedDate->format('Y');

    if ($daysName === true) {
        return "{$dayOfWeek}, {$day}-{$month}-{$year}";
    } else {
        return "{$day}-{$month}-{$year}";
    }
}

// function MakeInv()
// {
//     $invFrm = date('y') . date('m');
//     $db = new Database();
//     $lastInv = $db->table("tbl_sale_mst")->select(['MAX(inv) AS inv'])->get();
//     $lastInv = $lastInv[0]['inv'];

//     if ($lastInv != '' || $lastInv != null || $lastInv != 0) {
//         $invFiext = substr($lastInv, 0, 4);
//         $lastNum = (int)substr($lastInv, strlen($invFrm));
//         $nextNum = $lastNum + 1;
//         if ($invFrm == $invFiext) {
//             return $invFiext . $nextNum;
//         } else {
//             return $invFrm . '1';
//         }
//     } else {
//         return $invFrm . '1';
//     }
// }

function Permission($controllerName = "")
{
    $rolePermission = [    // role => controller name
        1 => ["*"],
        2 => ["dashboard"]
    ];

    if (strlen($controllerName) > 0) {
        $role = Session::Get("role");
        if ($role === 1 || in_array($controllerName, $rolePermission[$role])) {
            return true;
        }
    } else {
        return $rolePermission;
    }
}

function HigherPermission()
{
    $desigCode = [1];
    $role = (int) Session::Get("role");
    $permit = false;

    if (in_array($role, $desigCode)) {
        $permit = true;
    }

    return $permit;
}

function ValidateEmail($email)
{
    return filter_var($email, FILTER_VALIDATE_EMAIL);
}

/**
 * Return a JSON result message based on query outcome.
 * @param mixed $result The result of the database operation (e.g., affected rows or error message)
 * @param int $type The type of operation: 1 for Insert, 2 for Update, 3 for Delete
 */
function ReturnResult($result, $type)
{
    header('Content-Type: application/json');
    if (strpos(strtolower($result), 'duplicate entry') !== false) {
        echo json_encode([
            'result' => false,
            'message' => 'Error: Duplicate entry found.'
        ]);
        exit;
    } else {
        if ($result) {
            $message = '';
            switch ($type) {
                case 1: // Insert
                    $message = 'Successfully added!';
                    break;
                case 2: // Update
                    $message = 'Successfully updated!';
                    break;
                case 3: // Delete
                    $message = 'Successfully deleted!';
                    break;
                default:
                    break;
            }
            echo json_encode([
                'result' => true,
                'message' => $message
            ]);
        } else {
            // If no rows were affected or any other error
            echo json_encode([
                'result' => false,
                'message' => getErrorMessage($type)
            ]);
        }
    }
}

/**
 * Get a default error message based on the operation type.
 *
 * @param int $type The type of operation: 1 for Insert, 2 for Update, 3 for Delete
 * @return string The error message
 */
function getErrorMessage($type)
{
    switch ($type) {
        case 1:
            return 'Error: Could not add the record.';
        case 2:
            return 'Error: Could not update the record.';
        case 3:
            return 'Error: Could not delete the record.';
        default:
            return 'Error: Something went wrong.';
    }
}
