$(document).ready(function(){
    table = $('#dataTable').DataTable({
        "order": [],
        ajax: {
            url: 'event/list',
            type: 'POST',
            data: {
                t: 'c'
            },
            dataSrc: function(json) {
                return json.data;
            },
        },
        columns: [
            {
                data: null,
                render: function (data) { 
                    return sDate(data['booking_date_time']);
                 }
                },
            {data: 'client_name'},
            {data: 'phone'},
            {data: 'event_type'},
            {
                data: null,
                render: function (data, type, row) { 
                    var packageName=data['package_type'];
                    return packageName.substring(0, packageName.length-2);
                }
            },
            {data: 'package_amount'},
            {
                data: null,
                render: function (data) { 
                    return sDate(data['event_date_time']);
                 }
            },
            {
                data: null,
                render: function (data) { 
                    return sTime(data['event_date_time']);
                 }
            },
            {
                data: null,
                render: function(data, type, row) {
                    return '<div class="btn-group">'+
                                '<button type="button" name="payment" class="btn btn-sm action-btn" onclick="PaymentDetails('+row.id+')">Details</button>'+
                                '<a class="btn btn-sm action-btn" href="../print/payment_summary.php?id='+row.id+'" target="_blank" rel="noopener noreferrer"><i class="bi bi-printer-fill"></i></a>'+
                            '</div>';
                }
            }
        ]
    });
});