<?php

class event extends sController
{
    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        $this->home();
    }

    public function home()
    {
        $type = $_GET["t"];
        switch ($type) {
            case 'p':
                $this->pending();
                break;
            case 'c':
                $this->complete();
                break;
            default:
                $this->view('home');
                break;
        }
    }

    public function pending()
    {
        $this->view("pending");
    }

    public function complete()
    {
        $this->view("complete");
    }

    public function assignModal()
    {
        $id = $_POST["id"];
        $event = $this->model->GetEventById($id);
        $empList = $this->load->Model("employee")->List(true);
        $assignedEmp = $this->model->GetAssignedEmpByEventId($id);

        $data = ["event" => $event, "empList" => $empList, "assignedEmp" => $assignedEmp];
        $this->viewModal("modal_assign_emp", $data);

        // if ($id > 0) {
        //     $agent = $this->model->getById($id);
        //     $this->load->ViewModal("agent/modal", array(
        //         "title" => "Update Agent Info",
        //         "agent" => $agent
        //     ));
        // } else {
        //     $this->load->ViewModal("agent/modal", array(
        //         "title" => "Add New Agent",
        //         "agent" => null
        //     ));
        // }
    }

    public function assign()
    {
        $event_id = $_POST['eventId'];
        $emp_id = $_POST['empId'];
        $shift_amt = $_POST['shiftPayable'];
        $shift_count = $_POST['shiftCount'];
        $total_shift_amt = $_POST['totalShiftPayable'];
        $hour_amt = $_POST['hourPayable'];
        $hour_count = $_POST['totalHour'];
        $total_hour_amt = $_POST['extraHourPayable'];
        $edit_fee = $_POST['editingFee'];
        $travel_cost = $_POST['travelCost'];
        $payable_amt = $_POST['totalPayable'];

        $hour_amt = $total_hour_amt > 0 ? $hour_amt : 0;

        $data = [
            'event_id' => $event_id,
            'emp_id' => $emp_id,
            'shift_amt' => $shift_amt,
            'shift_count' => $shift_count,
            'total_shift_amt' => $total_shift_amt,
            'hour_amt' => $hour_amt,
            'hour_count' => $hour_count,
            'total_hour_amt' => $total_hour_amt,
            'edit_fee' => $edit_fee,
            'travel_cost' => $travel_cost,
            'payable_amt' => $payable_amt,
            'create_by' => Session::Get('username'),
            'create_at' => CURRENT_DATE,
        ];

        $insert = "";
        try {
            $insert = ReturnResult($this->model->Assign($data),1);
        } catch (Exception $ex) {
            $insert = ReturnResult($ex->getMessage(), 1);
        }
        echo $insert;
        exit;
        
        $event = $this->model->GetEventById($event_id);

        $ledgerData = [
            'emp_id' => $emp_id,
            'event_id' => $event_id,
            'pay_id' => '',
            'date' => $event[0]['event_date_time'],
            'remarks' => $event[0]['id'] . '-' . $event[0]['event_type'] . ' (' . $event[0]['package_type'] . ')',
            'payable_amt' => $payable_amt,
            'payment' => 0,
            'type' => 'E',
        ];

        $this->load->Model("ledger")->Insert($ledgerData);

        return $insert;
    }

    public function list()
    {
        $complete = false;
        $dueList = false;
        if (isset($_POST["t"])) {
            switch ($_POST["t"]) {
                case 'p':
                    $dueList = true;
                    break;
                case 'c':
                    $complete = true;
                    break;
                default:
                    break;
            }
        }

        $list = $this->model->EventList($complete, $dueList);
        $permission = HigherPermission();
        header('Content-Type: application/json');
        echo json_encode(["data" => $list, "permission" => $permission]);
    }

    public function assignedEmpByEventId()
    {
        $id = $_GET["id"];
        $list = $this->model->GetAssignedEmpByEventId($id);
        header('Content-Type: application/json');
        echo json_encode(["data" => $list]);
    }


}
