<?php
include("../config/config.php");
include("../db/model.php");
$db = new Model();

$billNum = null;
$billMst = null;
$billDtl = null;
$payment = null;
$dueAmount = 0;

if (isset($_POST['billNum'])) {
	$billNum = $_POST['billNum'];
	$billMst = $db->GetBillMst(false, $billNum);
	$billDtl = $db->GetBillDtlByBillNumber($billNum);
	$payment = $db->GetBillPayByBillNum($billNum, false, false, true);

	$paymentValue = is_numeric($payment) ? (int) $payment : 0;
	$totalBillAmount = is_numeric($billMst["ttl_bill_amt"]) ? (int) $billMst["ttl_bill_amt"] : 0;
	$dueAmount = $totalBillAmount - $paymentValue;
}
?>

<!DOCTYPE html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="<?= BASE_URL ?>style/download.css">
	<title><?= strtoupper($billMst['name']) . "_Due_Bill_" . $billNum; ?></title>
</head>

<body>
	<div class="print-area">
		<!-- Report Header -->
		<div id="report-header">
			<table class="w-100">
				<tr>
					<td class="s-left">
						<img src="<?= BASE_URL ?>print/snapmoment_logo.png" width="260" />
					</td>
					<td class="s-right">
						<p class="s-mb-1">CLIENT BILL</p>
						<p class="s-bold s-my-1"><?= InvoicePrefix::BILL_NUMBER . $billNum; ?></p>
						Contact: +8801673-157878 <br>
						Location: House #478, Road-7, <br>
						Block- H, Bashundhara R/A, Dhaka.
					</td>
				</tr>
			</table>
		</div>
		<!-- Report Body -->
		<div id="report-body">
			<table class="w-100 s-my-2">
				<tr>
					<td>
						To,<br />
						&nbsp;&nbsp;<strong><?= strtoupper($billMst['name']); ?></strong>
					</td>
					<td class="s-right">
						Print Date: <b><?= sDate(date("Y-m-d H:i:s"), true) ?></b>
					</td>
				</tr>
			</table>
			<table class="s-table s-table-border-black-600 s-mb-2">
				<thead class="s-bg-black-600 s-text-white">
					<tr class="s-center">
						<th style="width:100px">ID / Date</th>
						<th>Description</th>
						<th style="width:160px">Duration</th>
						<th style="width:120px">Amount (BDT)</th>
					</tr>
				</thead>
				<tbody>
					<?php
					if (!empty($billDtl)) { // Added a check if $billDtl is not empty
						foreach ($billDtl as $index => $row) {
							$packageName = "Package: <b>" . htmlspecialchars($row["package_name"]) . "</b>"; // htmlspecialchars for safety
							$addTimeArr = AdditionalTimeArr($row["add_time"]);
							$packageArr = PackageArr($row["package_dtl"]);
							$addOnsArr = AddOnsArr($row["addons"]);
							$outdoorAmt = (float) ($row["outdoor_amt"] ?? 0);
							$packageDtl = '';
							if (!empty($packageArr)) {
								foreach ($packageArr as $value) {
									$packageDtl .= "<br><b> • " . htmlspecialchars($value["title"]) . "</b>";
									$packageDtl .= "<br>" . htmlspecialchars($value["details"]);
								}
							}
							$outdoor = null;
							$outdoorDtl = null;
							$rowSpan = 1;
							if ($outdoorAmt > 0) {
								$rowSpan++;
								$outdoor = $db->GetEventOutdoor($row["event_id"]);
								$outdoorDtl = "Outdoor : ";
								$outdoorDtl .= ((int) ($outdoor["photog"] ?? 0) > 0) ? "<br><b> • Photographer ({$outdoor["photog"]})</b>":"";
								$outdoorDtl .= ((int) ($outdoor["cinemetog"] ?? 0) > 0) ? "<br><b> • Cinematographer ({$outdoor["cinemetog"]})</b>" : "";
								$outdoorDtl .= ((int) ($outdoor["drone"] ?? 0) > 0) ? "<br><b> • Drone ({$outdoor["drone"]})</b>" : "";
							}
							if (!empty($addTimeArr)) {
								$rowSpan++;
							}
							$addOnsDetails = '';
							$addOnsAmount = 0;
							$rowSpanAddOns = '';
							if (!empty($addOnsArr)) {
								// Adjust rowspan for the main row if add-ons are present
								$rowSpan++;
								$rowSpanAddOns = 'rowspan="2"';
								foreach ($addOnsArr as $value) {
									$addOnsDetails .= (empty($addOnsDetails) ? "" : "<br>") . "• " . htmlspecialchars($value["name"]) . " (" . htmlspecialchars($value["amount"]) . ")";
									$addOnsAmount += (int) $value["amount"];
								}
							}
							$description = $packageName . $packageDtl;
							$bgColor = ($index % 2) == 0 ? '' : 's-bg-silver-200';
							// Outdoor
							if ($outdoorAmt > 0) {
								echo '<tr class="' . $bgColor . '">';
								echo '<td class="s-center" rowspan="' . $rowSpan . '"> (' . $row["event_id"] . ')<br>' . sDate($row["event_date_time"]) . '</td>';
								echo '<td class="s-center">'.$outdoorDtl.'</td>';
								echo '<td class="s-center">' . $outdoor['hours'] . '</td>';
								echo '<td class="s-right">' . sTakaFormat($outdoor["amt"]) . '</td>';
								echo '</tr>';
							}
							// Package
							echo '<tr class="' . $bgColor . '">';
							echo ($outdoorAmt > 0) ? '' : '<td class="s-center" rowspan="' . $rowSpan . '"> (' . htmlspecialchars($row["event_id"]) . ')<br>' . sDate($row["event_date_time"]) . '</td>';
							echo '<td class="s-center">' . $description . '</td>';
							echo '<td class="s-center" ' . $rowSpanAddOns . '>' . htmlspecialchars($row["duration"]) . '</td>';
							echo '<td class="s-right">' . sTakaFormat($row["after_adj"]) . '</td>';
							echo '</tr>';
							// Add-ons
							if (!empty($addOnsArr)) {
								echo '<tr class="' . $bgColor . '">';
								echo '<td class="s-center">Add-Ons: <b>' . $addOnsDetails . '</b></td>';
								echo '<td class="s-right">' . sTakaFormat($addOnsAmount) . '</td>';
								echo '</tr>';
							}
							// Additional Time
							if (!empty($addTimeArr)) {
								echo '<tr class="' . $bgColor . '">';
								echo '<td class="s-center"><b>Additional Time</b></td>';
								echo '<td class="s-center">' . htmlspecialchars($addTimeArr["hours"]) . '</td>';
								echo '<td class="s-right">' . sTakaFormat($addTimeArr["amount"]) . '</td>';
								echo '</tr>';
							}
						}
						// Summary rows
						$displayBillAmount = isset($billMst["bill_amt"]) ? $billMst["bill_amt"] : 0;
						$displayDiscount = isset($billMst["discount"]) ? $billMst["discount"] : 0;
						echo '<tr class="">';
						echo '<td class="s-border-0 s-px-2" colspan="2" rowspan="2">In word: <b>' . sNumberToWords($dueAmount) . '</b></td>';
						echo '<td class="s-right"><b>Total :</b></td>';
						echo '<td class="s-right"><b>' . sTakaFormat($displayBillAmount) . '</b></td>';
						echo '</tr>';
						echo '<tr class="">';
						echo '<td class="s-right">Payment :</td>';
						echo '<td class="s-right">' . sTakaFormat($payment) . '</td>';
						echo '</tr>';
						if ((int) $displayDiscount > 0) {
							echo '<tr class="">';
							echo '<td class="s-border-0 s-right" colspan="2"></td>';
							echo '<td class="s-right">Special Discount :</td>';
							echo '<td class="s-right">' . sTakaFormat($displayDiscount) . '</td>';
							echo '</tr>';
						}
						echo '<tr class="">';
						echo '<td class="s-border-0 s-right" colspan="3"><b>Balance Due :</b></td>';
						echo '<td class="s-right s-bg-red-200"><b>' . sTakaFormat($dueAmount) . '</b></td>';
						echo '</tr>';
					} else {
						echo '<tr><td colspan="4" class="s-center">No bill details found.</td></tr>';
					}
					?>
				</tbody>
			</table>
			<?php if (!empty($billDtl)) { ?>
				<table class="w-100">
					<tr class="">
						<td>
							<img class="ms-4" src="<?= BASE_URL ?>print/raihan_signature.jpg" style="height: 100px;" />
						</td>
						<td class="s-center align-bottom">
							<?= ($dueAmount > 0) ? '' : '<img src="' . BASE_URL . 'print/paid.png" alt="" width="90">'; ?>
						</td>
					</tr>
				</table>
			<?php } ?>
			<!-- Report Footer -->
			<div id="report-footer">
				<table class="w-100">
					<tr>
						<td class="s-center">
							<img src="<?= BASE_URL ?>print/payment_method.jpg" height="130" />
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
</body>

</html>