<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['type']) && isset($_POST['data'])) {

    $type = trim($_POST['type']);
    $data = trim($_POST['data']);

    if (empty($type) || empty($data)) {
        include("../config/config.php");
        include('../content/shared/error.php');
        exit;
    }

    ob_start();

    switch ($type) {
        case 'bill':
            $_POST['billNum'] = $data;
            include("cust_bill.php");
            break;
        case 'eventConfirmation':
            $_POST['billNum'] = $data;
            include("event_confirmation.php");
            break;
        default:
            include("../config/config.php");
            include('../content/shared/error.php');
            exit;
    }

    $html = ob_get_clean();

    if (!$html) {
        include("../config/config.php");
        include('../content/shared/error.php');
        exit;
    }

    $printHtml = '
    <div class="s-center s-py-4">
		<input type="button" value="Print" class="s-btn s-btn-orange s-btn-print" onclick="window.print()">
	</div>

	<script>
		window.onload = function () {
			window.print();
		};
	</script>
    ';

    if (stripos($html, '</body>') !== false) {
        $html = str_ireplace('</body>', $printHtml . '</body>', $html);
    }
    
    echo $html;


} else {
    include("../config/config.php");
    include('../content/shared/error.php');
    exit;
}
