<?php
include('../db/model.php');
include('../config/config.php');
$db = new Model();
// $tableHeight='';
$forUpdate = false;
$id = 0;
$designation = $db->EmpDesigList();

if (isset($_POST['id'])) {
    $id = (int) $_POST['id'];
    if (is_numeric($id) && $id > 0 && $id != '' && $id != null) {
        $forUpdate = $id > 0;
        $addons = $db->GetAddOns(false,$id);
    }
}

if (isset($_POST['type'])) {
    if ($_POST['type'] == 'add') {
        $result = $db->AddAddOns($_POST);
        header('Content-Type: application/json');

        if (strlen($result) == 1) {
            echo json_encode(['success' => true, 'message' => 'ADD-ONS Successfully Added']);
        } else {
            echo json_encode(['success' => false, 'message' => $result]);
        }
    } else if ($_POST['type'] == 'update') {
        $result = $db->UpdateAddOns($_POST);
        header('Content-Type: application/json');

        if (strlen($result) == 1) {
            echo json_encode(['success' => true, 'message' => 'ADD-ONS Successfully Updated']);
        } else {
            echo json_encode(['success' => false, 'message' => $result]);
        }
    }
    exit;
}

?>
<div class="modal fade" id="modalModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
    aria-labelledby="modalModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header text-center">
                <h1 class="modal-title fs-5 w-100" id="modalModalLabel"><?php if ($forUpdate) {
                    echo 'Update ADD-ONS';
                } else {
                    echo 'Add New ADD-ONS';
                } ?></h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div id="custom-form-light">
                <div class="modal-body">

                    <input type="hidden" name="id" id="id" value="<?php if ($forUpdate) {
                        echo $addons['id'];
                    } ?>">

                    <div class="mb-3">
                        <label for="desig">Add-Ons Type</label>
                        <select name="desig" id="desig" class="form-control form-select">
                            <option value="0">Select one</option>
                            <?php 
                                foreach ($designation as $value) {
                                    echo '<option value="'.$value['id'].'" '.(($forUpdate && $value['name'] == $addons['name']) ? "selected":"").' >'.$value["name"].'</option>';
                                }
                            ?>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="name">Add Ons Name</label>
                        <input type="text" name="name" id="name" value="<?php if ($forUpdate) {
                            echo $addons['name'];
                        } ?>" class="form-control">
                    </div>

                    <div class="input-group">
                        <div class="col-12 col-sm-12 col-md-6 mb-3 pe-md-2">
                            <div class="input-group">
                                <label for="qty" class="input-group-text">Quantity</label>
                                <input type="number" name="qty" id="qty" value="<?= ($forUpdate) ? $addons['qty']: "0" ?>" class="form-control text-center">
                                
                                <label for="amount" class="input-group-text">Amount</label>
                                <input type="number" name="amount" id="amount" value="<?php if ($forUpdate) {
                                    echo $addons['amt'];
                                } ?>" class="form-control text-center">
                            </div>
                        </div>

                        <div class="col-12 col-sm-12 col-md-6 mb-3 ms-auto me-0 ps-md-2">
                            <label for="status">Status</label>
                            <div class="input-group">
                                <div class="form-check ps-5">
                                    <input class="form-check-input" type="radio" name="status" id="statusActive" <?php if ($forUpdate) {
                                        if ($addons['status'] == 1) {
                                            echo 'checked';
                                        }
                                    } ?>>
                                    <label class="form-check-label" for="statusActive">
                                        Active
                                    </label>
                                </div>
                                <div class="form-check ps-5">
                                    <input class="form-check-input" type="radio" name="status" id="statusDeActive" <?php if ($forUpdate) {
                                        if ($addons['status'] == 0) {
                                            echo 'checked';
                                        }
                                    } ?>>
                                    <label class="form-check-label" for="statusDeActive">
                                        De-Active
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                    <?php if ($forUpdate) { ?>
                        <button type="submit" class="btn btn-primary" onclick="UpdateAddOns()">Update</button>
                    <?php } else { ?>
                        <button type="submit" class="btn btn-primary" onclick="AddAddOns()">Add</button>
                    <?php } ?>

                </div>
            </div>
            <!-- </form> -->
        </div>
    </div>
</div>

<script>
    $(document).on('change', "#desig", function (){
        var id = $(this).val();
        var name = $("#desig option:selected").text();
        
        $("#name").val(id>0?name:'');
    });
</script>