<?php
include('../db/model.php');
include('../config/config.php');
$db = new Model();
// $tableHeight='';
$forUpdate = false;
$id = 0;

$package_list = $db->PackageList();

if (isset($_POST['id'])) {
    $id = (int) $_POST['id'];
    if (is_numeric($id) && $id > 0 && $id != '' && $id != null) {
        $forUpdate = $id > 0;
        $packageDetails = $db->GetPackageDetailsById($id);
    }
}

if (isset($_POST['type'])) {
    if ($_POST['type'] == 'add') {
        $result = $db->AddPackageDetails($_POST);
        header('Content-Type: application/json');

        if (strlen($result) == 1) {
            echo json_encode(['success' => true, 'message' => 'Package Details Successfully Added']);
        } else {
            echo json_encode(['success' => false, 'message' => $result]);
        }
    } else if ($_POST['type'] == 'update') {
        $result = $db->UpdatePackageDetails($_POST);
        header('Content-Type: application/json');

        if (strlen($result) == 1) {
            echo json_encode(['success' => true, 'message' => 'Package Details Successfully Updated']);
        } else {
            echo json_encode(['success' => false, 'message' => $result]);
        }
    }
    exit;
}

?>
<div class="modal fade" id="modalModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
    aria-labelledby="modalModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="modal-header text-center">
                <h1 class="modal-title fs-5 w-100" id="modalModalLabel"><?php if ($forUpdate) {
                    echo 'Update Package Details';
                } else {
                    echo 'Add New Package Details';
                } ?></h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div id="custom-form-light">
                <div class="modal-body">

                    <input type="hidden" name="id" id="id" value="<?php if ($forUpdate) {
                        echo $packageDetails['id'];
                    } ?>">

                    <div class="mb-3">
                        <label for="packageName">Package Name</label>
                        <select id="packageName" name="packageName" class="form-control">
                            <option value="">Select Package</option>
                            <?php
                            foreach ($package_list as $package) {
                                echo '<option value="' . $package['id'] . '" data-package-amount="' . $package['amt'] . '" ';
                                if ($forUpdate) {
                                    echo ($package['id'] == $packageDetails['package_id']) ? "selected" : "";
                                }
                                echo '>';
                                echo $package['name'];
                                echo '</option>';
                            }
                            ?>

                        </select>
                    </div>

                    <div class="row">
                        <div class="col-12 col-md-8 mb-3">
                            <label for="title">Title</label>
                            <input type="text" name="title" id="title" value="<?php if ($forUpdate) {
                                echo $packageDetails['title'];
                            } ?>" class="form-control">
                        </div>
                        <div class="col-12 col-md-4 mb-3">
                            <label for="order">Order</label>
                            <input type="number" name="order" id="order" value="<?php if ($forUpdate) {
                                echo $packageDetails['order'];
                            } ?>" placeholder="1" class="form-control">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="details">Details</label>
                        <input type="text" name="details" id="details" value="<?php if ($forUpdate) {
                            echo $packageDetails['details'];
                        } ?>" class="form-control">
                    </div>

                    <div class="mb-3">
                        <label for="packageDetailsStatus">Status</label>
                        <div class="input-group">
                            <div class="form-check ps-5">
                                <input class="form-check-input" type="radio" name="packageDetailsStatus"
                                    id="packageDetailsStatusActive" <?php if ($forUpdate) {
                                        if ($packageDetails['status'] == 1) {
                                            echo 'checked';
                                        }
                                    } ?>>
                                <label class="form-check-label" for="packageDetailsStatusActive">
                                    Active
                                </label>
                            </div>
                            <div class="form-check ps-5">
                                <input class="form-check-input" type="radio" name="packageDetailsStatus"
                                    id="packageDetailsStatusDeActive" <?php if ($forUpdate) {
                                        if ($packageDetails['status'] == 0) {
                                            echo 'checked';
                                        }
                                    } ?>>
                                <label class="form-check-label" for="packageDetailsStatusDeActive">
                                    De-Active
                                </label>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                    <?php if ($forUpdate) { ?>
                        <button type="submit" class="btn btn-primary" onclick="UpdatePackageDetails()">Update</button>
                    <?php } else { ?>
                        <button type="submit" class="btn btn-primary" onclick="AddPackageDetails()">Add</button>
                    <?php } ?>

                </div>
            </div>
            <!-- </form> -->
        </div>
    </div>
</div>

<script>
    loadSelect2(['#packageName'], '#modalModal');
</script>