$(document).ready(function() {
  table = $('#dataTable').DataTable({
      order: [],
      ajax: {
          url: 'employee.php',
          type: 'POST',
          data: {
              type: 'empList'
          },
          dataSrc: function(json) {
              return json;
          },
      },
      columns: [{
              data: 'full_name'
          },
          {
              data: 'designation'
          },
          {
              data: 'phone_number'
          },
          {
              data: 'email'
          },
          {
              data: 'address'
          },
          {
              data: 'salary'
          },
          {
              data: null,
              render: function(data) {
                return sStatus(data['status']);
              }
          },
          {
              data: null,
              render: function(data, type, row) {
                  var btn = '<div class="text-center"><div class="btn-group">';
                  btn += '<button type="button" class="btn btn-sm action-btn" onclick="EmpDetail(' + row.id + ')"><i class="bi bi-pencil-fill"></i></button>';
                  btn += '</div></div>';
                  return btn;
              }
          }
      ]
  });
});

function EmpDetail(id) {
  $.ajax({
    type: "post",
    url: "modal_emp.php",
    data: {
      id: id,
    },
    success: function (sData) {
      $("#modalDiv").html("");
      $("#modalDiv").append(sData);
      $("#modalModal").modal("show");
    },
  });
}

function AddEmp() {
  var fullName = $("#mFullName").val();
  var email = $("#mEmail").val();
  var phoneNumber = $("#mPhoneNumber").val();
  var address = $("#mAddress").val();
  var salary = $("#mSalary").val();
  var empDesig = $("#designation").val();
  var empStatus = document.getElementById('mUserStatusActive').checked ? 1 : 0;

  if (fullName === "" || fullName === null) {
    $("#mFullName").css("border-color", "red");
    return;
  }

  if (email === "" || email === null) {
    $("#mEmail").css("border-color", "red");
    return;
  }

  if (phoneNumber === "" || phoneNumber === null) {
    $("#mPhoneNumber").css("border-color", "red");
    return;
  }

  if (address === "" || address === null) {
    $("#mAddress").css("border-color", "red");
    return;
  }

  $.ajax({
    type: "post",
    url: "modal_emp.php",
    data: {
      type: "add",
      fullName: fullName,
      email: email,
      phoneNumber: phoneNumber,
      address: address,
      salary: salary,
      status: empStatus,
      desig: empDesig
    },
    success: function (response) {
      if (response.success) {
        $("#modalModal").modal("hide");
        table.ajax.reload();
        swal(response.message, {
          icon: "success",
        });
      } else {
        swal('Error: ' + response.message, {
          icon: "error",
        });
      }
    },
  });
}

function UpdateEmp() {
  var id = $("#mId").val();
  var fullName = $("#mFullName").val();
  var email = $("#mEmail").val();
  var phoneNumber = $("#mPhoneNumber").val();
  var address = $("#mAddress").val();
  var salary = $("#mSalary").val();
  var empDesig = $("#designation").val();
  var empStatus = document.getElementById('mUserStatusActive').checked ? 1 : 0;

  if (fullName === "" || fullName === null) {
    $("#mFullName").css("border-color", "red");
    return;
  }

  if (email === "" || email === null) {
    $("#mEmail").css("border-color", "red");
    return;
  }

  if (phoneNumber === "" || phoneNumber === null) {
    $("#mPhoneNumber").css("border-color", "red");
    return;
  }

  if (address === "" || address === null) {
    $("#mAddress").css("border-color", "red");
    return;
  }

  swal({
    title: "Are you sure?",
    text: "Update this employee!",
    icon: "warning",
    buttons: true,
    dangerMode: true,
  }).then((willDelete) => {
    if (willDelete) {
      $.ajax({
        type: "post",
        url: "modal_emp.php",
        data: {
          type: "update",
          id: id,
          fullName: fullName,
          email: email,
          phoneNumber: phoneNumber,
          address: address,
          salary: salary,
          status: empStatus,
          desig: empDesig
        },
        success: function (response) {
          if (response.success) {
            $("#modalModal").modal("hide");
            table.ajax.reload();
            swal(response.message, {
              icon: "success",
            });
          } else {
            swal('Error: ' + response.message, {
              icon: "error",
            });
          }
        },
      });
    }
  });
}
