CREATE TABLE
    `quote_mst` (
        `id` INT NOT NULL AUTO_INCREMENT,
        `client_name` VARCHAR(200) NOT NULL,
        `purpose` VARCHAR(255) NOT NULL,
        `amount` INT NOT NULL DEFAULT 0,
        PRIMARY KEY (`id`)
    );

CREATE TABLE
    `quote_details` (
        `id` INT NOT NULL AUTO_INCREMENT,
        `mst_id` INT NOT NULL,
        `event_date` DATE NOT NULL,
        `location` VARCHAR(255) NOT NULL,
        `package_id` INT NOT NULL,
        `package_name` VARCHAR(100) NOT NULL,
        `package_amt` FLOAT NOT NULL DEFAULT 0,
        `add_ons_id` INT NOT NULL DEFAULT 0,
        `add_ons_name` VARCHAR(100) NOT NULL,
        `add_ons_amt` FLOAT NOT NULL DEFAULT 0,
        `purpose` VARCHAR(200),
        `event_time` VARCHAR(100) NOT NULL,
        `report_time` VARCHAR(100) NOT NULL,
        `photog` VARCHAR(100) NOT NULL,
        `cinemetog` VARCHAR(100) NOT NULL,
        `event_type` VARCHAR(100) NOT NULL,
        `duration` VARCHAR(100) NOT NULL,
        `total` FLOAT NOT NULL DEFAULT 0,
        PRIMARY KEY (`id`),
        CONSTRAINT `quote_details_mst_id_fk` FOREIGN KEY (`mst_id`) REFERENCES `quote_mst` (`id`)
    );

CREATE TABLE
    `quote_others` (
        `id` INT NOT NULL AUTO_INCREMENT,
        `mst_id` INT NOT NULL,
        `edited_photo` VARCHAR(100) NOT NULL,
        `printed_photo` VARCHAR(100) NOT NULL,
        `photo_quality` VARCHAR(100) NOT NULL,
        `promo` VARCHAR(100) NOT NULL,
        `video` VARCHAR(100) NOT NULL,
        `album` VARCHAR(100) NOT NULL,
        `pf_10l` VARCHAR(100) NOT NULL,
        `drone` VARCHAR(100) NOT NULL,
        PRIMARY KEY (`id`),
        CONSTRAINT `quote_others_mst_id_fk` FOREIGN KEY (`mst_id`) REFERENCES `quote_mst` (`id`)
    );


DROP Table quote_others