<?php
include('../db/model.php');
include('../config/config.php');
$obj = new Model();
// $tableHeight='';
$forUpdate = false;
$id = 0;

if (isset($_POST['id'])) {
    $id = (int)$_POST['id'];
    if (is_numeric($id) && $id > 0 && $id != '' && $id != null) {
        $forUpdate = $id > 0;
        $package = $obj->GetPackageById($id);
    }
}

if (isset($_POST['type'])) {
    if ($_POST['type'] == 'add') {
        $result = $obj->AddPackage($_POST);
        header('Content-Type: application/json');

        if (strlen($result) == 1) {
            echo json_encode(['success' => true, 'message' => 'Package Successfully Added']);
        } else {
            echo json_encode(['success' => false, 'message' => $result]);
        }
    } else if ($_POST['type'] == 'update') {
        $result = $obj->UpdatePackage($_POST);
        header('Content-Type: application/json');

        if (strlen($result) == 1) {
            echo json_encode(['success' => true, 'message' => 'Package Successfully Updated']);
        } else {
            echo json_encode(['success' => false, 'message' => $result]);
        }
    }
    exit;
}

?>
<div class="modal fade" id="modalModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="modalModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header text-center">
                <h1 class="modal-title fs-5 w-100" id="modalModalLabel"><?php if ($forUpdate) {
                                                                            echo 'Update Package';
                                                                        } else {
                                                                            echo 'Add New Package';
                                                                        } ?></h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div id="custom-form-light">
                <div class="modal-body">

                    <input type="hidden" name="id" id="id" value="<?php if ($forUpdate) {
                                                                        echo $package['id'];
                                                                    } ?>">

                    <div class="mb-3">
                        <label for="name">Package Name</label>
                        <input type="text" name="name" id="name" value="<?php if ($forUpdate) {
                                                                            echo $package['name'];
                                                                        } ?>" class="form-control">
                    </div>

                    <div class="input-group">
                        <div class="col-12 col-sm-12 col-md-6 mb-3 pe-md-2">
                            <label for="amount">Package Amount</label>
                            <input type="number" name="amount" id="amount" value="<?php if ($forUpdate) {
                                                                                echo $package['amt'];
                                                                            } ?>" class="form-control">
                        </div>

                        <div class="col-12 col-sm-12 col-md-6 mb-3 ms-auto me-0 ps-md-2">
                            <label for="packageStatus">Status</label>
                            <div class="input-group">
                                <div class="form-check ps-5">
                                    <input class="form-check-input" type="radio" name="packageStatus" id="packageStatusActive" <?php if ($forUpdate) {
                                                                                                                                    if ($package['status'] == 1) {
                                                                                                                                        echo 'checked';
                                                                                                                                    }
                                                                                                                                } ?>>
                                    <label class="form-check-label" for="packageStatusActive">
                                        Active
                                    </label>
                                </div>
                                <div class="form-check ps-5">
                                    <input class="form-check-input" type="radio" name="packageStatus" id="packageStatusDeActive" <?php if ($forUpdate) {
                                                                                                                                        if ($package['status'] == 0) {
                                                                                                                                            echo 'checked';
                                                                                                                                        }
                                                                                                                                    } ?>>
                                    <label class="form-check-label" for="packageStatusDeActive">
                                        De-Active
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                    <?php if ($forUpdate) { ?>
                        <button type="submit" class="btn btn-primary" onclick="UpdatePackage()">Update</button>
                    <?php } else { ?>
                        <button type="submit" class="btn btn-primary" onclick="AddPackage()">Add</button>
                    <?php } ?>

                </div>
            </div>
            <!-- </form> -->
        </div>
    </div>
</div>