<?php
$_page_title = "Quotation";
$_main_root = '../';

require_once $_main_root . 'db/model.php';

$db = new Model();

$package = $db->PackageList(true);
$addOns = $db->AddOnsList(true);

if (isset($_POST['type'])) {
    header('Content-Type: application/json');
    $type = $_POST['type'];

    if ($type == "get") {
        $quoteMst = $db->GetQuotationMst(false, $_POST["id"]);
        $quoteOthers = $db->GetQuotationOthers($_POST["id"]);
        echo json_encode(["quoteMst" => $quoteMst, "quoteOthers" => $quoteOthers]);
    } elseif ($type == "add") {
        $result = $db->AddQuotationMst($_POST);
        echo json_encode(['flag' => $result]);
    } elseif ($type == "mst_update") {
        $result = $db->UpdateQuotationMst($_POST);
        echo json_decode($result);
    } elseif ($type == "detailsList") {
        $result = $db->GetQuotationDetails($_POST["quoteId"], false, true);
        echo json_encode($result);
    } elseif ($type == "addQuoteDetails") {
        $flag = $db->AddQuotationDetails($_POST);
        echo json_encode(["flag" => $flag]);
    } elseif ($type == "UpdateQuoteDetails") {
        $flag = $db->AddQuotationDetails($_POST, true);
        echo json_encode(["flag" => $flag]);
    } elseif ($type == "getDtl") {
        $flag = $db->GetQuotationDetails($_POST["dtlId"], true);
        echo json_encode($flag);
    } elseif ($type == "detailDelete") {
        $flag = $db->QuotationDelete($_POST["id"], $_POST["quotationId"]);
        echo json_encode($flag);
    } elseif ($type == "updateOthers") {
        $flag = $db->QuotationOthers($_POST);
        echo json_encode($flag);
    } elseif ($type == "updateBreakdown") {
        $flag = $db->UpdateQuotationCostBreakdown($_POST);
        echo json_encode($flag);
    }

    exit;
}

include($_main_root . 'content/common/header.php');

if (!Permission()) {
    return;
}
?>

<!-- modal -->
<div id="modalDiv"></div>

<div class="container container-fluid">
    <div class="my-4">
        <h2 class="text-center" style="color:var(--s-text-color);">CUSTOMER QUOTATION</h2>
        <input type="hidden" name="hQuoteId" id="hQuoteId" value="">
    </div>

    <div class="row my-4">
        <div class="card bg-dark" style="border-color: var(--s-text-color);">
            <div class="card-body text-white">

                <div class="row" id="custom-form-dark">
                    <div class="col-12 col-md-4 col-xl-4 mt-1">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">Client Name :</span>
                            <input type="text" id="client_name" class="form-control" value="">
                        </div>
                    </div>
                    <div class="col-12 col-md-5 col-xl-6 mt-1">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">Purpose :</span>
                            <input type="text" id="purpose" class="form-control" value="">
                        </div>
                    </div>
                    <div class="col-12 col-md-3 col-xl-2 text-end mt-1" id="quoteMstActionBtn">
                    </div>
                </div>

                <div class="d-flex align-items-center mt-3 mb-1 text-warning">
                    <hr class="flex-grow-1">
                    <span
                        class="px-3 fs-5 fw-bold border border-1 border-warning border-opacity-25 rounded-pill">Details</span>
                    <hr class="flex-grow-1">
                </div>

                <div class="row pt-3 section-details" id="custom-form-light">
                    <div class="mb-1 col-12 col-sm-6 col-md-4 col-xl-3">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">Date</span>
                            <input type="text" class="form-control" id="details_date" readonly>
                        </div>
                    </div>
                    <div class="mb-1 col-12 col-sm-6 col-md-4 col-xl-3">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">Location</span>
                            <input type="text" name="" id="details_location" value="-" class="form-control">
                        </div>
                    </div>
                    <div class="mb-1 col-12 col-sm-6 col-md-4 col-xl-3">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">Package</span>
                            <select name="" id="details_package" class="form-select">
                                <?php if (!empty($package)) {
                                    foreach ($package as $row) {
                                        echo '<option value="' . $row["id"] . '">' . $row["name"] . ' -' . sTakaFormat($row["after_discount"], false, true) . '</option>';
                                    }
                                } ?>
                            </select>
                        </div>
                    </div>
                    <div class="mb-1 col-12 col-sm-6 col-md-4 col-xl-3">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">Add Ons</span>
                            <select name="" id="details_add_ons" class="form-select">
                                <option value="0">Select Add-Ons</option>
                                <?php if (!empty($addOns)) {
                                    foreach ($addOns as $row) {
                                        echo '<option value="' . $row["id"] . '">' . $row["name"] . ' -' . sTakaFormat($row["amt"], false, true) . '</option>';
                                    }
                                } ?>
                            </select>
                        </div>
                    </div>
                    <div class="mb-1 col-12 col-sm-6 col-md-4 col-xl-3">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">Event Time</span>
                            <input type="text" name="" id="details_event_time" value="-" class="form-control">
                        </div>
                    </div>
                    <div class="mb-1 col-12 col-sm-6 col-md-4 col-xl-3">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">Reporting Time</span>
                            <input type="text" name="" id="details_report_time" value="-" class="form-control">
                        </div>
                    </div>
                    <div class="mb-1 col-12 col-sm-6 col-md-4 col-xl-3">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">Photographer</span>
                            <input type="text" name="" id="details_photog" value="1" class="form-control text-center">
                        </div>
                    </div>
                    <div class="mb-1 col-12 col-sm-6 col-md-4 col-xl-3">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">Cinemetographer</span>
                            <input type="text" name="" id="details_cinemetog" value="1"
                                class="form-control text-center">
                        </div>
                    </div>
                    <div class="mb-1 text-end" id="details_btn"></div>

                    <div class="mb-1 col-12">
                        <div class="table-responsive-lg">
                            <table class="table table-sm w-100 table-dark table-bordered" id="detailsTable">
                                <thead>
                                    <tr>
                                        <th style="width: 120px;">Event Date</th>
                                        <th style="">Location</th>
                                        <th style="">Package</th>
                                        <th style="width: 200px">Event Time</th>
                                        <th style="width: 5px">Amount</th>
                                        <th style="width: 5px;">Action</th>
                                    </tr>
                                </thead>
                                <tbody class="text-center"></tbody>
                            </table>
                        </div>

                    </div>
                </div>

                <div class="d-flex align-items-center mt-3 mb-1 text-warning">
                    <hr class="flex-grow-1">
                    <span
                        class="px-3 fs-5 fw-bold border border-1 border-warning border-opacity-25 rounded-pill">Others</span>
                    <hr class="flex-grow-1">
                </div>

                <div class="row pt-3 section-others" id="custom-form-light">
                    <div class="mb-1 col-12 col-sm-6 col-md-4 col-xl-3">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">Edited Photos</span>
                            <input type="text" name="" id="others_edit_photo" value="All"
                                class="form-control text-center">
                        </div>
                    </div>
                    <div class="mb-1 col-12 col-sm-6 col-md-4 col-xl-3">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">Printed Photos</span>
                            <input type="text" name="" id="others_print_photo" value="-"
                                class="form-control text-center">
                        </div>
                    </div>
                    <div class="mb-1 col-12 col-sm-6 col-md-4 col-xl-3">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">Photo Quantity</span>
                            <input type="text" name="" id="others_photo_quality" value="Unlimited"
                                class="form-control text-center">
                        </div>
                    </div>
                    <div class="mb-1 col-12 col-sm-6 col-md-4 col-xl-3">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">Promo</span>
                            <input type="text" name="" id="others_promo" value="1" class="form-control text-center">
                        </div>
                    </div>
                    <div class="mb-1 col-12 col-sm-6 col-md-4 col-xl-3">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">Video</span>
                            <input type="text" name="" id="others_video" value="1" class="form-control text-center">
                        </div>
                    </div>
                    <div class="mb-1 col-12 col-sm-6 col-md-4 col-xl-3">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">Album</span>
                            <input type="text" name="" id="others_album" value="-" class="form-control text-center">
                        </div>
                    </div>
                    <div class="mb-1 col-12 col-sm-6 col-md-4 col-xl-3">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">Photo Frame (10L)</span>
                            <input type="text" name="" id="others_photo_frame10l" value="-"
                                class="form-control text-center">
                        </div>
                    </div>
                    <div class="mb-1 col-12 col-sm-6 col-md-4 col-xl-3">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">Drone</span>
                            <input type="text" name="" id="others_drone" value="-" class="form-control text-center">
                        </div>
                    </div>
                    <div class="mb-1 text-end">
                        <button type="button" class="btn btn-sm bg-success border-white text-white px-3"
                            id="others_update">Add Others</button>
                    </div>
                </div>

                <div class="d-flex align-items-center mt-3 mb-1 text-warning">
                    <hr class="flex-grow-1">
                    <span class="px-3 fs-5 fw-bold border border-1 border-warning border-opacity-25 rounded-pill">Cost
                        Breakdown</span>
                    <hr class="flex-grow-1">
                </div>

                <div class="row pt-3 section-breakdown" id="custom-form-light">
                    <div class="mb-1 col-12 col-sm-6 col-xl-5">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">Event Type</span>
                            <textarea rows="2" name="" id="breakdown_event_type" class="form-control text-center"></textarea>
                        </div>
                    </div>
                    <div class="mb-1 col-12 col-sm-6 col-xl-5">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">Package Duration</span>
                            <textarea rows="2" name="" id="breakdown_duration" class="form-control text-center"></textarea>
                        </div>
                    </div>
                    <div class="mb-1 col-12 col-xl-2 text-end" id="breakdownBtn"></div>

                    <div class="mb-1 col-12">
                        <div class="table-responsive-lg">
                            <table class="table table-sm w-100 table-dark table-bordered" id="tableBreakdown">
                                <thead>
                                    <tr>
                                        <th style="">Purpose</th>
                                        <th style="">Event Type</th>
                                        <th style="">Package Duration</th>
                                        <th style="width: 100px">Price (BDT)</th>
                                        <th style="width: 5px;">Action</th>
                                    </tr>
                                </thead>
                                <tbody class="text-center"></tbody>
                            </table>
                        </div>

                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<?php $s_scripts = ['cust_quotation']; ?>
<?php include($_main_root . 'content/common/footer.php'); ?>