<?php
$_page_title = "Employee";
$_main_root = '../';
require_once $_main_root . 'db/model.php';

$db = new Model();
if (isset($_POST['type'])) {
    if ($_POST['type'] == "empList") {
        $empList = $db->EmployeeList();
        header('Content-Type: application/json');
        echo json_encode($empList);
        exit;
    }
}

include($_main_root . 'content/shared/header.php');
?>

<!-- modal -->
<div id="modalDiv"></div>

<div class="container container-fluid">
    <div class="my-4 d-flex justify-content-between align-items-center">
        <h2 style="color:var(--s-text-color);">EMPLOYEE LIST</h2>
        <div>
            <?php if ($db->sAccess("emp_payment", "view")) { ?>
                <a href="emp_payment.php" class="btn btn-sm btn-outline-info ms-3">PAYMENT</a>
            <?php }?>
            <?php if ($sa) { ?>
                <button class="btn btn-sm btn-outline-info" onclick="EmpDetail(0)">
                <i class="bi bi-plus-circle me-2"></i> NEW EMPLOYEE
            </button>
            <?php }?>
        </div>
    </div>

    <div class="row my-4">
        <div class="table-responsive-lg">
            <table id="dataTable" class="table table-sm table-dark table-hover table-bordered" style="width: 100%;">

                <thead style="color:var(--s-text-color);" class="mt-3">
                    <!-- <th>#</th> -->
                    <th class="">Full Name</th>
                    <th>Designation</th>
                    <th style="width: 50px;">Phone</th>
                    <th style="width: 50px;">Email</th>
                    <th>Address</th>
                    <th style="width: 50px;">Salary</th>
                    <th style="width: 80px;">Status</th>
                    <th style="width: 50px;">Action</th>
                </thead>
                <tbody>
                </tbody>
            </table>

        </div>
    </div>
</div>

<?php $s_scripts = ['emp']; ?>
<?php include($_main_root . 'content/shared/footer.php'); ?>