<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $to = $_POST['to_email'];
    $cc = $_POST['cc_email'];

    // Example dynamic data from form or database
    $event_name = $_POST['event_name'] ?? "Sample Event";
    $booking_date = $_POST['booking_date'] ?? date('d-M-Y');
    $event_date = $_POST['event_date'] ?? date('d-M-Y', strtotime('+7 days'));
    $location = $_POST['location'] ?? "Main Hall";

    $subject = "Event Booking Confirmation";

    // HTML Email Template
    $htmlContent = "
    <html>
    <head>
      <title>$subject</title>
      <style>
        body { font-family: Arial, sans-serif; background-color: #f5f5f5; margin: 0; padding: 0; }
        .container { background-color: #fff; padding: 20px; margin: 20px auto; border-radius: 8px; width: 600px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        h2 { color: #333; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        td { padding: 8px; border: 1px solid #ddd; }
        .label { font-weight: bold; background-color: #f0f0f0; width: 30%; }
      </style>
    </head>
    <body>
      <div class='container'>
        <h2>Event Booking Confirmation</h2>
        <p>Dear Participant,</p>
        <p>Thank you for booking. Here are your event details:</p>
        <table>
          <tr>
            <td class='label'>Event Name:</td>
            <td>$event_name</td>
          </tr>
          <tr>
            <td class='label'>Booking Date:</td>
            <td>$booking_date</td>
          </tr>
          <tr>
            <td class='label'>Event Date:</td>
            <td>$event_date</td>
          </tr>
          <tr>
            <td class='label'>Location:</td>
            <td>$location</td>
          </tr>
        </table>
        <p>We look forward to seeing you!</p>
      </div>
    </body>
    </html>
    ";

    // Email headers
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= "From: no-reply@example.com\r\n";
    if(!empty($cc)){
        $headers .= "Cc: $cc\r\n";
    }

    // Send email
    if(mail($to, $subject, $htmlContent, $headers)){
        echo "<script>alert('Email sent successfully!'); window.location.href='index.php';</script>";
    } else {
        echo "<script>alert('Failed to send email.'); window.location.href='index.php';</script>";
    }
} else {
    header('Location: index.php');
}
?>
