<?php
session_start();

$_main_root = '../';
include($_main_root . "content/manage.php");
include($_main_root . "db/model.php");
$obj = new Model();

if (!isset($_login_page) || !$_login_page) {
    
    if (!isset($_SESSION['username'])) {
        header("Location: " . $_main_root . "index.php");
        exit();
    }
}

$pay=null;
if(isset($_GET['eid'])){
	$emp_id=$_GET['eid'];
	if($emp_id>0){
		$pay = $obj->GetLastEmpPayByEmpId($emp_id);
	}
}

if(isset($_GET['id'])){
	$id=$_GET['id'];
	if($id>0){
		$pay = $obj->GetEmpPayById($id);
	}
}


?>

<!DOCTYPE html>
<html>

<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<!-- Bootstrap CSS -->
	<link rel="stylesheet" href="<?php echo $_main_root; ?>style/bootstrap-5.3.0/css/bootstrap.min.css">

	<title>Payment</title>

	<style>
		body {
			font-family: 'Times New Roman', Times, serif;
		}

		.invoice-box {
			max-width: 900px;
			margin: auto;
			font-size: 16px;
			line-height: 24px;
			/* font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif; */
			color: #000;
		}

		@media print {
			body * {
				visibility: hidden;
			}

			@page {
				size: A4 portrait
			}

			.container_content,
			.container_content * {
				visibility: visible;
			}
		}
	</style>

</head>

<body>
	
	<div class="container_content">
		<div class="invoice-box">
			<table class="w-100" style="background-color:#E6E6E6;">
				<tr>
					<td>
						<img src="snapmoment_logo.png" style="width: 100%; max-width: 300px; margin-top: 20px !important; margin-left: -22px !important; " />
					</td>
					<td style="text-align: right;">
						<h3 style="margin-top: 20px; margin-right: 15px;">INVOICE</h3><br /><br />
						<p style="margin-right: 15px; font-size:20px;">Date : <?php echo sDate($pay['pay_date']);?></p>
						<p style="margin-right: 15px; font-size:22px;"><strong>Invoice No: <?php echo $obj->InvoicePrefixEmpPay.$pay['invoice']; ?></strong></p>

					</td>
				</tr>
			</table>

			<!-- company address and client contact -->
			<table class="my-3 w-100">
				<tr>
					<td></td>
					<td style="text-align: right; margin-right: 10px;">
						Contact: +8801673-157878 <br />
						Location: House #478, Road-7, Block- H, <br />
						Bashundhara R/A, Dhaka
					</td>
				</tr>
				<tr>
				<td>
					To ,<br />
						<h5>
							<strong><?php echo strtoupper($pay['full_name']);?></strong> <br />
							<?php echo $pay['designation'];?> <br />
						</h5>
						Contact: <?php echo $pay['phone_number'];?> <br />
						Email: <?php echo $pay['email'];?>
					</td>

				</tr>
			</table>

			<!-- Payment details table -->
			<table class="table table-bordered border-dark mt-1">
				<thead class="table-dark">
					<tr class="text-center" style="font-size: 20px;">
						<th>Payment Date</th>
						<th>Description</th>
						<th >Amount</th>
					</tr>
				</thead>
				<tbody>
					<tr class="text-center">
						<td><?php echo sDate($pay['pay_date']);?></td>
						<td><?php echo $pay['remarks'];?></td>
						<td style="text-align:right"><?php echo $pay['amt'];?></td>
					</tr>
					
					<tr class="text-center border-0">
						<td class="border-0"></td>
						<th class="border-1" style="text-align: right; background-color:#E6E6E6;">Due : </th>
						<th class="border-1" style="text-align: right"><?php echo $pay['due_amt'];?></th>
					</tr>

				</tbody>
			</table>

			<!-- signature and paid logo -->

			<table class="w-100">
				<tr>
					<td>
						<img class="mt-4 ms-4" src="raihan_signature.jpg" style="height: 120px; " />
					</td>
					<td style="text-align: right">
						<?php if($pay['due_amt']==0){
							echo '<img class="mt-4 me-5" src="paid.png" style="height: 200px; " />';
						} ?>
					</td>
				</tr>
			</table>
		

		</div>

	</div>

	<div class="text-center" style="padding:20px;">
		<input type="button" value="Download" class="btn btn-success btn_print" onclick="print_invoice()">
	</div>

	<script src="<?php echo $_main_root; ?>style/DataTables/jQuery-3.6.0/jquery-3.6.0.min.js"></script>
	<script src="<?php echo $_main_root; ?>style/bootstrap-5.3.0/js/bootstrap.bundle.min.js"></script>

	<script>
		$(document).ready(function() {
			window.print();
		});

		function print_invoice() {
			window.print();
		}
	</script>
</body>

</html>