<?php
include('../db/model.php');
include('../config/config.php');
$obj = new Model();

$empList = $obj->EmployeeList();

if (isset($_POST["type"])) {
    if ($_POST["type"] == "bill") {
        $emp_id=$_POST['emp_id'];
        $firstDate=$_POST['firstDate'];
        $lastDate=$_POST['lastDate'];
        $empEventList = $obj->GetAssignedEventByEmpId($emp_id, $firstDate, $lastDate);
        header('Content-Type: application/json');
        echo json_encode($empEventList);
        exit;
    }
}

?>

<style>
    #dataTable tbody td:nth-child(1) {
        text-align: center;
    }

    #dataTable tbody td:nth-child(3),
    #dataTable tbody td:nth-child(4) {
        text-align: end;
    }
</style>

<div class="row">
    <div class="mb-3 row justify-content-center">
        <div class="col-12 col-md-4 mb-3">
            <select name="empList" id="empList" class="form-control empBill">
                <option value="">Select Employee</option>
                <?php foreach ($empList as $row): ?>
                    <option value="<?php echo $row['id']; ?>">
                        <?php echo $row['full_name']; ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-12 col-md-4 mb-3" id="">
            <select name="monthList" id="monthList" class="form-control empBill">
                <option value="">Select Month</option>
                <?php foreach ($monthsNameFull as $index => $month): ?>
                    <option value="<?php echo $index + 1; ?>" <?php echo ($index + 1 == $currentMonth) ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($month); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-12 col-md-4 mb-3" id="">
            <select name="yearList" id="yearList" class="form-control empBill">
                <option value="">Select Year</option>
                <?php
                for ($year = $currentYear; $year >= 2024; $year--) {
                    echo '<option value="' . $year . '" ' . ($year == $currentYear ? 'selected' : '') . '>' . $year . '</option>';
                }
                ?>
            </select>
        </div>
    </div>
</div>

<div class="table-responsive">
    <table id="dataTable" class="table table-sm table-dark table-hover table-bordered" style="width: 100%;">
        <thead style="color:var(--s-text-color);" class="mt-3">
            <tr>
                <th style="width: 100px">Date</th>
                <th>Event Details</th>
                <th style="width: 70px;">Payable</th>
                <th style="width: 70px;">Payment</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>

</div>

<script>
    $(document).ready(function() {
        loadSelect2(['#empList']);
        loadSelect2(['#monthList']);
        loadSelect2(['#yearList']);
        
        var table = $('#dataTable').DataTable({
                "searching": false,
                "ordering": false,
            });
        
        $('.empBill').on('change', function() {
            var emp_id = $('#empList').val();
            var month = $('#monthList').val(); // month is 1-based (1 for Jan, 2 for Feb, etc.)
            var year = $('#yearList').val();

            var firstDate = new Date(year, month - 1, 1);
            var lastDate = new Date(year, month, 0);

            // Formatting the dates to YYYY-MM-DD
            var firstDateF = sDate(firstDate, true);
            var lastDateF = sDate(lastDate, true);

            table.clear();
            table.draw();

            if (emp_id > 0) {
                if (month == null || month == '') {
                    swal("Please check Month", {
                        icon: "warning",
                    });
                } else if (year == null || year == '') {
                    swal("Please check Year", {
                        icon: "warning",
                    });
                } else {
                    $.ajax({
                        type: "post",
                        url: "report_emp_bill.php",
                        data: {
                            type: 'bill',
                            emp_id: emp_id,
                            firstDate: firstDateF,
                            lastDate: lastDateF,
                        },
                        success: function(response) {
                            console.log(response);
                            table.clear();
                            if (response.length > 0) {
                                response.forEach(function(item) {
                                    var row = [
                                        sDate(item.date),
                                        item.remarks,
                                        item.payable_amt,
                                        item.payment,
                                    ];
                                    table.row.add(row).draw();
                                });
                            }
                        }
                    });
                }
            } else {
                swal("Please select Employee", {
                    icon: "warning",
                });
            }
        });

        $('#printBtnEmpBill').on('click', function(e) {
            var emp_id = $('#empList').val();
            var month = $('#monthList').val(); // month is 1-based (1 for Jan, 2 for Feb, etc.)
            var year = $('#yearList').val();

            var firstDate = new Date(year, month - 1, 1);
            var lastDate = new Date(year, month, 0);

            var reportFor=monthsNameFull[month-1]+'-'+year;

            // Formatting the dates to YYYY-MM-DD
            var firstDateF = sDate(firstDate, true);
            var lastDateF = sDate(lastDate, true);

            if (CheckPrint()) {
                var printUrl = "../print/emp_bill.php?ei=" + emp_id + "&f=" + firstDateF + "&t=" + lastDateF+"&r="+reportFor;
                window.open(printUrl, "_blank");
            }
        });

    });
</script>