function PaymentForm(id) {
  $.ajax({
    type: "post",
    url: "modal_payment.php",
    data: {
      type: "form",
      id: id,
    },
    success: function (sData) {
      $("#paymentModalDiv").html("");
      $("#paymentModalDiv").append(sData);
      $("#paymentModal").modal("show");
    },
  });
}

function PaymentDetails(id) {
  $.ajax({
    type: "post",
    url: "modal_payment.php",
    data: {
      type: "details",
      id: id,
    },
    success: function (sData) {
      $("#paymentModalDiv").html("");
      $("#paymentModalDiv").append(sData);
      $("#paymentModal").modal("show");
    },
  });
}

function MakePayment() {
  var id = $("#mId").val();
  var payment_amt = $("#mPaymentAmount").val();
  var comment = $("#mComment").val();

  // data-bs-dismiss="modal"

  if (payment_amt == "" || payment_amt == null || payment_amt == 0) {
    $("#mPaymentAmount").css("border-color", "red");
    return;
  }

  var printUrl = "../print/invoice.php?lp=" + id;

  $.ajax({
    type: "post",
    url: "modal_payment.php",
    data: {
      type: "payment",
      booking_id: id,
      payment_amt: payment_amt,
      comment: comment,
    },
    success: function (sData) {
      $("#paymentModal").modal("hide");
      table.ajax.reload();
      window.open(printUrl, "_blank");
    },
  });
}

function PaymentEditForm(payId) {
  var eventId = $("#mId").val();

  $("#paymentModal").modal("hide");
  $("#paymentModalDiv").html("");

  $.ajax({
    type: "post",
    url: "modal_payment.php",
    data: {
      type: "editForm",
      eventId: eventId,
      payId: payId,
    },
    success: function (sData) {
      $("#paymentModalDiv").html("");
      $("#paymentModalDiv").append(sData);
      $("#paymentModal").modal("show");
    },
  });
}

function UpdatePayment(payId) {
  var payment_amt = $("#mPaymentAmount").val();
  var comment = $("#mComment").val();

  if (payment_amt == "" || payment_amt == null || payment_amt == 0) {
    $("#mPaymentAmount").css("border-color", "red");
    return;
  }

  swal({
    title: "Are you sure?",
    text: "Update this payment!",
    icon: "warning",
    buttons: true,
    dangerMode: true,
  }).then((willDelete) => {
    if (willDelete) {
      $.ajax({
        type: "post",
        url: "modal_payment.php",
        data: {
          type: "update",
          payId: payId,
          payment_amt: payment_amt,
          comment: comment,
        },
        success: function (sData) {
          $("#paymentModal").modal("hide");
          table.ajax.reload();
          swal("Successfully updated!", {
            icon: "success",
          });
        },
      });
    }
  });
}

function PaymentDelete(payId) {
  swal({
    title: "Are you sure?",
    text: "Once deleted, you will not be able to recover this collection!",
    icon: "warning",
    buttons: true,
    dangerMode: true,
  }).then((willDelete) => {
    if (willDelete) {
      $.ajax({
        type: "post",
        url: "modal_payment.php",
        data: {
          type: "delete",
          payId: payId,
        },
        success: function (sData) {
          $("#paymentModal").modal("hide");
          table.ajax.reload();
          swal("Poof! Your file has been deleted!", {
            icon: "success",
          });
        },
      });
    }
  });
}

function Discount() {  
  var id = $("#mId").val();
  var discount_amt = $("#mDiscountAmount").val();

  // data-bs-dismiss="modal"

  if (discount_amt == "" || discount_amt == null || discount_amt < 0) {
    $("#mDiscountAmount").css("border-color", "red");
    return;
  }

  $.ajax({
    type: "post",
    url: "modal_payment.php",
    data: {
      type: "discount",
      booking_id: id,
      discount_amt: discount_amt,
    },
    success: function (sData) {
      if (sData===0) {
        swal("Please contact sys provider", {
          icon: "warning",
        });
      } else{
        swal("Successfully applyed discount", {
          icon: "success",
        });
        $("#paymentModal").modal("hide");
        table.ajax.reload();
        PaymentForm(id);
      }
    },
  });
}