$(document).ready(function () {
  table = $('#dataTable').DataTable({
    order: [],
    ajax: {
      url: 'package_details.php',
      type: 'POST',
      data: {
        type: 'list'
      },
      dataSrc: function (json) {
        return json;
      },
    },
    columns: [
      { data: 'package_name' },
      { data: 'title' },
      { data: 'details' },
      {
        data: null,
        render: function (data) {
          return sStatus(data['status']);
        }
      },
      {
        data: null,
        render: function (data, type, row) {
          var btn = '<div class="text-center"><div class="btn-group">';
          btn += '<button type="button" class="btn btn-sm action-btn" onclick="DetailPackageDetails(' + row.id + ')"><i class="bi bi-pencil-fill"></i></button>';
          btn += '</div></div>';
          return btn;
        }
      }
    ]
  });
});

function DetailPackageDetails(id = 0) {
  $.ajax({
    type: "post",
    url: "modal_package_details.php",
    data: {
      id: id,
    },
    success: function (sData) {
      $("#modalDiv").html("");
      $("#modalDiv").append(sData);
      $("#modalModal").modal("show");
    },
  });
}

function AddPackageDetails() {
  var package_id = $("#packageName").val();
  var title = $("#title").val();
  var details = $("#details").val();
  var status = document.getElementById('packageDetailsStatusActive').checked ? 1 : 0;

  if (package_id === "" || package_id === null || package_id < 0) {
    $(".select2-selection").css("border-color", "red");
    return;
  }

  if (title === "" || title === null) {
    $("#title").css("border-color", "red");
    return;
  }

  if (details === "" || details === null) {
    $("#details").css("border-color", "red");
    return;
  }

  $.ajax({
    type: "post",
    url: "modal_package_details.php",
    data: {
      type: "add",
      package_id: package_id,
      title: title,
      details: details,
      status: status
    },
    success: function (response) {
      if (response.success) {
        $("#modalModal").modal("hide");
        table.ajax.reload();
        swal(response.message, {
          icon: "success",
        });
      } else {
        swal('Error: ' + response.message, {
          icon: "error",
        });
      }
    },
  });
}

function UpdatePackageDetails() {
  var id = $("#id").val();
  var package_id = $("#packageName").val();
  var title = $("#title").val();
  var details = $("#details").val();
  var status = document.getElementById('packageDetailsStatusActive').checked ? 1 : 0;

  if (package_id === "" || package_id === null || package_id < 0) {
    $(".selection").css("border-color", "red");
    return;
  }

  if (title === "" || title === null) {
    $("#title").css("border-color", "red");
    return;
  }

  if (details === "" || details === null) {
    $("#details").css("border-color", "red");
    return;
  }

  swal({
    title: "Are you sure?",
    text: "Update this package details!",
    icon: "warning",
    buttons: true,
    dangerMode: true,
  }).then((willDelete) => {
    if (willDelete) {
      $.ajax({
        type: "post",
        url: "modal_package_details.php",
        data: {
          type: "update",
          id: id,
          package_id: package_id,
          title: title,
          details: details,
          status: status
        },
        success: function (response) {
          if (response.success) {
            $("#modalModal").modal("hide");
            table.ajax.reload();
            swal(response.message, {
              icon: "success",
            });
          } else {
            swal('Error: ' + response.message, {
              icon: "error",
            });
          }
        },
      });
    }
  });
}