$(document).ready(function () {
    loadSelect2(['#eventType', '#addonsList']);

    $('#packageList').select2({
        placeholder: 'Select Package',
        templateResult: formatPackage,
        templateSelection: formatPackage,
    });

    $.post('book_us.php', {
        type: 'packageList'
    }, function (response) {
        if (response && response.items) {
            $('#packageList').empty();

            $('#packageList').append('<option value="" data-amt="">Select Package</option>');

            $.each(response.items, function (index, data) {
                $('#packageList').append(`<option value="${data.id}" data-amt="${data.amt}" data-discount="${data.discount_amt}" data-after-discount="${data.after_discount}">${data.name}</option>`);
            });

            $('#packageList').trigger('change');
        }
    }, 'json');

    function formatPackage(package) {
        if (!package.id) {
            return package.text;
        }

        var amount = $(package.element).data('amt');
        var discountAmount = $(package.element).data('discount');
        var afterDiscount = $(package.element).data('after-discount');

        var formattedText = `<span>${package.text}</span> - `;
        if (discountAmount > 0) {
            formattedText += `<span class="text-danger"><del>${sCurrencySymbol() + amount}</del></span> `;
        }
        formattedText += `<span>${sCurrencySymbol() + afterDiscount}</span>`;

        return $(formattedText);
    }

    $('#packageList, #eventType, #addonsList').on('select2:open select2:open select2:open', function (e) {
        $('.select2-dropdown').addClass('custom-form-1');
    });

    function conditional_form() {
        $('.s-cond-field').hide();
        $('#groom_name, #bride_name, #birthday_person, #organization_name, #amount, #location, #event_date_time').prop('required', false);

        var eventType = $('#eventType').val();
        var package = $('#packageList').val();

        if (
            eventType == 1 ||   // Wedding
            eventType == 2 ||   // Reception
            eventType == 3 ||   // Engagement
            eventType == 4 ||   // Halud
            eventType == 5 ||   // Mehadi
            eventType == 6 ||   // Akhd
            eventType == 7 ||   // Anniversary
            eventType == 8 ||   // Rong Khela
            eventType == 9      // Ashirbad
        ) {
            $('.groom_name, .packages_Field').show();
            $('#groom_name, #bride_name').prop('required', true);
        } else if (eventType == 10) { // Birthday
            $('.birthday_person, .packages_Field').show();
            $('#birthday_person').prop('required', true);
        } else if (
            eventType == 11 ||  // Architectural
            eventType == 12     // Corporate
        ) {
            $('.organization_name, .amount, .location_event_date_time').show();
            $('#organization_name, #amount, #location, #event_date_time').prop('required', true);
        } else if (eventType == 13) { // Fashion & Lifetyle
            $('.amount, .location_event_date_time').show();
            $('#amount, #location, #event_date_time').prop('required', true);
        }

        if (
            package == 1 ||   // Standard - I
            package == 2 ||   // Standard - II
            package == 3 ||   // Standard - III
            package == 4 ||   // Premium - I
            package == 5 ||   // Premium - II
            package == 6 ||   // Premium - III
            package == 7 ||   // Elite - I
            package == 8 ||   // Elite - II
            package == 9 ||   // Sonaton - Standrad
            package == 10 ||  // Sonaton - Premium
            package == 11 ||  // Only Photography
            package == 12     // Only Photography - Premium
        ) {
            $('.addons_Field, .location_event_date_time, .song_preference, .your_preference').show();
            $('#location, #event_date_time').prop('required', true);
        } else if (package == 13) { // Other
            $('.addons_Field, .amount, .location_event_date_time, .your_preference').show();
            $('#amount, #location, #event_date_time').prop('required', true);
        }
    }

    $('#eventType, #packageList').change(function () {
        conditional_form();
    });

    conditional_form();

});