<?php
$amountSign = '/-';
$user_roles = [
    1 => 'Super Admin',
    2 => 'Admin',
    3 => 'User'
];

$user_status = [
    0 => 'DE-ACTIVE',
    1 => 'ACTIVE'
];

$currentMonth = date('n'); // Current month (1 to 12)
$currentYear = date("Y");

$daysNameShort = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
$daysNameFull = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
$monthsNameShort = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
$monthsNameFull = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];

function Permission($role_required = 1)
{
    if (session_status() == PHP_SESSION_NONE) {
        session_start();
    }

    if (isset($_SESSION['desig'])) {
        $user_role = $_SESSION['desig'];

        if ($user_role == $role_required || $user_role == 1) {
            return true;
        }
    }

    return false;
}

function sCurrencySymbol($beforSpace = true, $afterSpace = true)
{
    $symble = '&#2547;';
    $currencySymble = $symble;
    if ($beforSpace) {
        $currencySymble = "&nbsp;" . $currencySymble;
    }
    if ($afterSpace) {
        $currencySymble = $currencySymble . "&nbsp;";
    }
    return $currencySymble;
}

function sDateToMillisecond($dateString, $timezone = 'UTC')
{
    $dateTime = DateTime::createFromFormat('Y-m-d H:i:s', $dateString, new DateTimeZone($timezone));
    if ($dateTime === false) {
        return false;
    }
    $seconds = $dateTime->getTimestamp();
    $millisecond = $seconds * 1000;
    return $millisecond;
}

function sDateFromMillisecond($millisecond, $timezone = 'UTC')
{
    $date = new DateTime();
    $seconds = (int)$millisecond / 1000;
    $date->setTimestamp($seconds);
    $date->setTimezone(new DateTimeZone($timezone));
    return $date->format('Y-m-d H:i:s');
}

function sDate($date, $daysName = false)
{
    global $daysNameShort, $monthsNameShort;

    $formattedDate = new DateTime($date);

    $dayName = $daysNameShort[$formattedDate->format('w')];
    $day = $formattedDate->format('d');
    $monthName = $monthsNameShort[$formattedDate->format('m') - 1];
    $year = $formattedDate->format('Y');

    if ($daysName) {
        return "{$dayName}, {$day}-{$monthName}-{$year}";
    } else {
        return "{$day}-{$monthName}-{$year}";
    }
}

function sTime($date, $use12HourFormat = true, $hideSecond = true)
{
    $formattedDate = new DateTime($date);

    $hours = (int)$formattedDate->format('H');
    $minutes = $formattedDate->format('i');
    $seconds = $formattedDate->format('s');

    $period = '';
    if ($use12HourFormat) {
        $period = ($hours >= 12) ? ' PM' : ' AM';
        $hours = $hours % 12;
        if ($hours == 0) {
            $hours = 12;
        }
        $hours = str_pad($hours, 2, '0', STR_PAD_LEFT);
    } else {
        $hours = str_pad($hours, 2, '0', STR_PAD_LEFT);
    }

    return "{$hours}:{$minutes}" . ($hideSecond ? '' : ":{$seconds}") . "{$period}";
}
