var InvoicePrefixEmpPay = '#E-INV-';
var daysNameShort = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
var daysNameFull = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
var monthsNameShort = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
var monthsNameFull = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];

$(document).ready(function() {
    $('.select2').select2();

    $(document).on('select2:open', (event) => {
        event.stopPropagation();
        setTimeout(() => {
            const searchField = document.querySelector('.select2-search__field');
            if (searchField) {
                searchField.focus();
            }
        }, 100);
    });
});

$.extend(true, $.fn.dataTable.defaults, {
    oLanguage: {
        sLengthMenu: "Show _MENU_ Entries",
    },
    aLengthMenu: [
        [10, 25, 50, 100, -1],
        [10, 25, 50, 100, "All"],
    ],
    iDisplayLength: 25,
    order: [],
    // bSort: false,
});

$.ajaxSetup({
    error: function (xhr, status, error) {
        var errorMessage = "An unknown error occurred.";

        if (xhr.status === 0) {
            errorMessage = "Network error: Please check your internet connection.";
        } else if (xhr.status === 404) {
            errorMessage = "Error 404: The requested resource was not found.";
        } else if (xhr.status === 500) {
            errorMessage = "Error 500: Internal server error occurred.";
        } else if (status === 'parsererror') {
            errorMessage = "Error: Failed to parse the response. The server may be returning an invalid JSON format.";
        } else {
            errorMessage = "Error " + xhr.status + ": " + error;
        }

        swal(errorMessage, {
            icon: "error",
        });

        // console.error("AJAX Error:", xhr, status, error);
    }
});

var user_roles = {
    1: 'Super Admin',
    2: 'Admin',
    3: 'User'
};

var user_status = {
    0: 'DE-ACTIVE',
    1: 'ACTIVE'
};

function sCurrencySymbol(beforeSpace = true, afterSpace = true) {
    var symbol = '&#2547;';
    var currencySymbol = symbol;

    if (beforeSpace) {
        currencySymbol = '&nbsp;' + currencySymbol;
    }

    if (afterSpace) {
        currencySymbol = currencySymbol + '&nbsp;';
    }

    return currencySymbol;
}


function getCookie(name) {
    var match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
    if (match) return match[2];
}

function Permission(roleRequired = 1) {
    var userRole = getCookie('desig');

    if (userRole && (userRole === roleRequired.toString() || userRole === '1')) {
        return true;
    }

    return false;
}

function sDate(date, standardFormat = false, daysName = false) {
    var formattedDate = new Date(date);

    var day = formattedDate.getDate().toString().padStart(2, '0');
    var monthNumber = (formattedDate.getMonth() + 1).toString().padStart(2, '0');

    var dayName = daysNameShort[formattedDate.getDay()];
    var monthName = monthsNameShort[formattedDate.getMonth()];
    var year = formattedDate.getFullYear();

    if (daysName) {
        return `${dayName}, ${day}-${monthName}-${year}`;
    } else {
        return (standardFormat) ? `${year}-${monthNumber}-${day}` : `${day}-${monthName}-${year}`;
    }
}

function sTime(date, use12HourFormat = true, hideSecond = true) {
    var formattedDate = new Date(date);

    var hours = formattedDate.getHours();
    var minutes = formattedDate.getMinutes().toString().padStart(2, '0');
    var seconds = formattedDate.getSeconds().toString().padStart(2, '0');

    var period = '';
    if (use12HourFormat) {
        period = hours >= 12 ? ' PM' : ' AM';
        hours = hours % 12 || 12;
        hours = hours.toString().padStart(2, '0');
    } else {
        hours = hours.toString().padStart(2, '0');
    }

    return `${hours}:${minutes}${hideSecond ? '' : ':' + seconds}${period}`;
}

function CheckPrint(tableId = "dataTable") {
    var table = $('#' + tableId).DataTable();

    if (table.rows().count() === 0) {
        swal("No data available to print", {
            icon: "warning",
        });
        return false;
    }

    return true;
}

function loadSelect2(selects, dropdownParentSelector = null) {
    if (Array.isArray(selects) && selects.length > 0) {
        selects.forEach(function (select) {
            if (!$(select).hasClass("select2-hidden-accessible")) {
                let select2Options = {};
                if (dropdownParentSelector) {
                    select2Options.dropdownParent = $(dropdownParentSelector);
                }
                $(select).select2(select2Options);
            }
        });
    }
}

function sStatus(statusCode) {
    var statusClass = statusCode == 1 ? 'text-success' : 'text-danger';
    var statusText = user_status[statusCode];
    return `<div class="text-center"><span class="fw-bold ${statusClass}"> ${statusText} </span></div>`;
}