<?php
$_page_title = "Booking Form";
$_main_root = '';
require_once $_main_root . 'db/model.php';
$db = new Model();

$package_list = null;

if (isset($_SESSION['username'])) {
    $_login_page = false;
    $_main_root = 'content/';
} else {
    $_login_page = true;
    $_public_form = true;
}

if (isset($_POST['type'])) {
    if ($_POST['type'] == 'packageList') {
        $package_list = $db->PackageList(true);
        header('Content-Type: application/json');
        echo json_encode(['items' => $package_list]);
    }
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $client_name = trim($_POST['client_name'] ?? '');
    $contact_no = trim($_POST['contact_no'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $event_type = trim($_POST['eventType'] ?? '');
    $groom_name = trim($_POST['groom_name'] ?? '');
    $bride_name = trim($_POST['bride_name'] ?? '');
    $birthday_person = trim($_POST['birthday_person'] ?? '');
    $package = trim($_POST['packageList'] ?? '');
    $organization_name = trim($_POST['organization_name'] ?? '');
    $amount = trim($_POST['amount'] ?? '');
    $location = trim($_POST['location'] ?? '');
    $event_date_time = trim($_POST['event_date_time'] ?? '');
    $song_preference = trim($_POST['song_preference'] ?? '');

    if (empty($client_name) || empty($contact_no) || empty($email)) {
        die('Please fill in all required fields.');
    }

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        die('Invalid email format');
    }

    $preferences = [];
    if (isset($_POST['couplePhotos'])) {
        $preferences[] = 'Couple Photos';
    }
    if (isset($_POST['candidPhotos'])) {
        $preferences[] = 'Candid Photos';
    }
    if (isset($_POST['outdoorPhotos'])) {
        $preferences[] = 'Outdoor Photos';
    }
    if (isset($_POST['familyPhotos'])) {
        $preferences[] = 'Family Photos';
    }
    if (isset($_POST['guestPhotos'])) {
        $preferences[] = 'Guest Photos';
    }
    if (isset($_POST['others'])) {
        $preferences[] = 'Others';
    }

    $preferences_str = implode(",", $preferences);

    $data = [
        'client_name' => $client_name,
        'contact_no' => $contact_no,
        'email' => $email,
        'event_type' => $event_type,
        'groom_name' => $groom_name,
        'bride_name' => $bride_name,
        'birthday_person' => $birthday_person,
        'package' => $package,
        'organization_name' => $organization_name,
        'amount' => $amount,
        'location' => $location,
        'event_date_time' => $event_date_time,
        'song_preference' => $song_preference,
        'your_preference' => $preferences_str
    ];

    echo '<pre>';
    print_r($data);
    print_r($_POST);
}

$event_type_list = $db->EventTypeList(true);
$addons_list = $db->AddOnsList(true);

include($_main_root . "content/common/header.php");
?>

<div id="modalDiv"></div>
<img src="img/booking_cover.jpg" alt="" width="100%">
<div class="container container-fluid d-flex justify-content-center">

    <div id="custom-form-1" class="col-12 col-md-8 p-4 m-3">
        <form action="" method="post" class="was-validated">
            <input type="hidden" name="eventId" id="eventId" value="">
            <div class="row mb-3">
                <div class="col-12">
                    <label for="" class="form-label">Client's Name</label>
                    <input type="text" name="client_name" id="client_name" class="form-control" value="" required>
                </div>
            </div>
            <div class="row">
                <div class="col-12 col-md-6 mb-3">
                    <label for="" class="form-label">Contact No.</label>
                    <input type="number" name="contact_no" id="contact_no" class="form-control" value="" placeholder="01794-600995" required>
                </div>
                <div class="col-12 col-md-6 mb-3">
                    <label for="" class="form-label">Email</label>
                    <input type="email" name="email" id="email" class="form-control" value="" placeholder="example@mail.com" required>
                </div>
            </div>
            <div class="row mb-3">
                <div class="col-12">
                    <label for="" class="form-label">Event's Type</label>
                    <select id="eventType" name="eventType" class="form-control" required>
                        <option value="">Select Event Type</option>
                        <?php
                        foreach ($event_type_list as $event_type) {
                            echo '<option value="' . $event_type['id'] . '">' . $event_type['name'] . '</option>';
                        }
                        ?>
                    </select>
                </div>
            </div>
            <div class="row s-cond-field groom_name">
                <div class="col-12 col-md-6 mb-3">
                    <label for="" class="form-label">Groom's Name</label>
                    <input type="text" name="groom_name" id="groom_name" class="form-control" value="">
                </div>
                <div class="col-12 col-md-6 mb-3">
                    <label for="" class="form-label">Bride's Name</label>
                    <input type="text" name="bride_name" id="bride_name" class="form-control" value="">
                </div>
            </div>
            <div class="row mb-3 s-cond-field birthday_person">
                <div class="col-12">
                    <label for="" class="form-label">Birthday Person's Name</label>
                    <input type="text" name="birthday_person" id="birthday_person" class="form-control" value="">
                </div>
            </div>
            <div class="row mb-3 s-cond-field organization_name">
                <div class="col-12">
                    <label for="" class="form-label">Organization's Name</label>
                    <input type="text" name="organization_name" id="organization_name" class="form-control" value="">
                </div>
            </div>
            <div class="row mb-3 s-cond-field packages_Field">
                <div class="col-12">
                    <label for="" class="form-label">Packages</label>
                    <select id="packageList" name="packageList" class="form-control" required>
                    </select>
                </div>
            </div>
            <div class="row mb-3 s-cond-field addons_Field">
                <div class="col-12">
                    <label for="" class="form-label">Add Ons</label>
                    <select id="addonsList" name="addonsList" class="form-control">
                        <option value="">Select Event Type</option>
                        <?php
                        foreach ($addons_list as $addons) {
                            echo '<option value="' . $addons['id'] . '">' . $addons['name'] . ' -'.sCurrencySymbol() .$addons['amt'] .'</option>';
                        }
                        ?>
                    </select>
                </div>
            </div>
            <div class="row mb-3 s-cond-field amount">
                <div class="col-12">
                    <label for="" class="form-label">Amount</label>
                    <input type="number" name="amount" id="amount" class="form-control" value="" placeholder="Enter Your Package Amount">
                </div>
            </div>
            <div class="row s-cond-field location_event_date_time">
                <div class="col-12 col-md-6 mb-3">
                    <label for="" class="form-label">Venue Location</label>
                    <input type="text" name="location" id="location" class="form-control" value="">
                </div>
                <div class="col-12 col-md-6 mb-3">
                    <label for="" class="form-label">Date / Time</label>
                    <input type="datetime-local" step="1800" name="event_date_time" id="event_date_time" class="form-control" value="">
                </div>
            </div>
            <div class="row mb-3 s-cond-field song_preference">
                <div class="col-12">
                    <label for="" class="form-label">Song Preference</label>
                    <input type="text" name="song_preference" id="song_preference" class="form-control" value="">
                    <div class="s-alert-warning mt-1">
                        If you want to suggest any song in your <strong>CINEMATOGRAPHY</strong>, you can give the link or name here.
                    </div>
                </div>
            </div>
            <div class="row mb-3 s-cond-field your_preference">
                <label for="" class="form-label">Your Preference</label>
                <div class="col-6 col-md-6">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="Couple Photos" id="couplePhotos" name="couplePhotos">
                        <label class="form-check-label" for="couplePhotos">
                            Couple Photos
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="Candid Photos" id="candidPhotos" name="candidPhotos">
                        <label class="form-check-label" for="candidPhotos">
                            Candid Photos
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="Outdoor Photos" id="outdoorPhotos" name="outdoorPhotos">
                        <label class="form-check-label" for="outdoorPhotos">
                            Outdoor Photos
                        </label>
                    </div>
                </div>
                <div class="col-6 col-md-6">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="Family Photos" id="familyPhotos" name="familyPhotos">
                        <label class="form-check-label" for="familyPhotos">
                            Family Photos
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="Guest Photos" id="guestPhotos" name="guestPhotos">
                        <label class="form-check-label" for="guestPhotos">
                            Guest Photos
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="Others" id="others" name="others">
                        <label class="form-check-label" for="others">
                            Others
                        </label>
                    </div>
                </div>
                <div class="col-12">
                    <div class="s-alert-warning mt-1">
                        <div>Note:</div>
                        <div class="ps-2"> ❐ For <strong>Standard</strong> and <strong>Only Photography</strong> packages, we accept only two preferences from booking form.</div>
                        <div class="ps-2"> ❐ Your <strong>booking</strong> will be confirmed after paying <strong>50%</strong> within <strong>72 hours</strong>.</div>
                    </div>
                </div>
            </div>
            <div class="d-flex justify-content-center">
                <button type="submit" class="btn px-4 mt-3 action-btn-2" onclick="">Book Now</button>
            </div>
        </form>
    </div>

</div>

<?php $s_scripts = ['book_us']; ?>
<?php include($_main_root . "content/common/footer.php"); ?>

<script>
    document.getElementById('event_date_time').addEventListener('input', function() {
    let dateTime = this.value;
    let [date, time] = dateTime.split('T');
    let [hours, minutes] = time.split(':');

    // Round minutes to nearest 30
    if (parseInt(minutes) < 30) {
        minutes = '00';
    } else {
        minutes = '30';
    }

    // Update the input value with the rounded time
    this.value = `${date}T${hours}:${minutes}`;
});

</script>