<style>
    body {
        display: flex;
        justify-content: center;
        align-items: center;
        min-height: 100vh;
        background: #081b29;
    }

    .wrapper {
        position: relative;
        width: auto;
        height: auto;
        background: transparent;
        border: 2px solid #0ef;
        border-radius: 20px;
        box-shadow: 0 0 25px #0ef;
        overflow: hidden;
    }

    .wrapper .form-box {
        position: relative;
        top: 0;
        width: 100%;
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    .wrapper .form-box.login {
        padding: 30px 40px;
        z-index: 100;
    }

    .wrapper.active .form-box.login {
        z-index: 0;
    }

    .wrapper .form-box.login .animation {
        transform: translateX(0);
        opacity: 1;
        filter: blur(0);
        transition: .7s ease;
        transition-delay: calc(.1s * var(--i));
    }

    .wrapper.active .form-box.login .animation {
        transform: translateX(-120%);
        opacity: 0;
        filter: blur(10px);
        transition-delay: calc(.1s * var(--i));
    }

    .wrapper .form-box.register {
        position: absolute;
        text-align: center;
        z-index: 0;
    }

    .wrapper.active .form-box.register {
        transform: .7 ease;
        z-index: 100;
    }

    .wrapper .form-box.register .animation {
        transform: translateX(120%);
        opacity: 0;
        filter: blur(10px);
        transition: .7s ease;
        transition-delay: calc(.1s * var(--i));
    }

    .wrapper.active .form-box.register .animation {
        transform: translateX(0);
        opacity: 1;
        filter: blur(0);
        transition-delay: calc(.1s * var(--i));
    }

    .wrapper.active .form-box.register p {
        color: #fff;
    }

    .form-box h2 {
        font-size: 32px !important;
        color: #fff;
        text-align: center;
        text-transform: uppercase;
    }

    .form-box .input-box {
        position: relative;
        width: 100%;
        height: 40px;
        margin: 25px 0;
    }

    .input-box input {
        width: 100%;
        height: 100%;
        background: transparent;
        border: none !important;
        outline: none !important;
        border-bottom: 2px solid #fff !important;
        padding: 0 23px 0 5px;
        font-size: 16px !important;
        color: #fff;
        font-weight: 500;
        transition: .5s;
    }

    .input-box input:focus,
    .input-box input:valid {
        border-bottom: 2px solid #0ef !important;
    }

    .input-box label {
        position: absolute;
        top: 50%;
        left: 0;
        transform: translateY(-50%);
        font-size: 16px !important;
        color: #fff;
        pointer-events: none;
        transition: .5s;
    }

    .input-box input:focus~label,
    .input-box input:valid~label {
        top: -5px;
        color: #0ef;
    }

    .input-box i {
        position: absolute;
        top: 50%;
        right: 0;
        transform: translateY(-50%);
        font-size: 18px !important;
        color: #fff;
        transition: .5s;
    }

    .input-box input:focus~i,
    .input-box input:valid~i {
        color: #0ef;
    }

    .btn-login {
        position: relative;
        width: 100%;
        height: 45px;
        background: transparent;
        border: 2px solid #0ef;
        outline: none;
        border-radius: 45px;
        cursor: pointer;
        font-size: 16px !important;
        color: #fff;
        font-weight: 600;
        z-index: 1;
        overflow: hidden;
    }

    .btn-login::before {
        content: "";
        position: absolute;
        top: -100%;
        left: 0;
        width: 100%;
        height: 300%;
        background: linear-gradient(#081b29, #0ef, #081b28, #0ef);
        z-index: -1;
        transition: .5s;
    }

    .btn-login:hover::before {
        top: 0;
    }

    .form-box .reg-link,
    .form-box .log-link {
        font-size: 14.5px !important;
        color: #fff;
        text-align: center;
        margin: 20px 0 10px;
    }

    .reg-link p a,
    .log-link p a {
        color: #0ef;
        text-decoration: none;
        font-weight: 600;
    }

    .reg-link p a:hover,
    .log-link p a:hover {
        text-decoration: underline;
    }


    /* For modern browsers */
    input:-webkit-autofill {
        -webkit-box-shadow: 0 0 0 30px transparent inset !important;
        -webkit-text-fill-color: white !important;
        transition: background-color 5000s ease-in-out 0s;
        /* Delay to override */
    }

    /* For Firefox */
    input:-moz-autofill {
        -moz-box-shadow: 0 0 0 30px transparent inset !important;
        -moz-text-fill-color: white !important;
        transition: background-color 5000s ease-in-out 0s;
        /* Delay to override */
    }

    /* For all other browsers */
    input:-ms-input-placeholder {
        -ms-transition: background-color 5000s ease-in-out 0s;
        /* Delay to override */
    }

</style>

<div class="wrapper">
    <div class="form-box login">
        <h2 class="animation" style="--i:0;">Login</h2>
        <form action="login/authentication" method="post">
            <div class="input-box animation" style="--i:1;">
                <input type="text" name="userName" id="userName" required>
                <label>Username</label>
                <i class="bi bi-person-fill"></i>
            </div>
            <div class="input-box animation" style="--i:2;">
                <input type="password" name="password" id="password" required>
                <label>Password</label>
                <i class="bi bi-lock-fill"></i>
            </div>
            <button type="submit" class="btn-login animation" style="--i:3;">Login</button>
            <div class="reg-link animation" style="--i:4;">
                <p>
                    Don't have an account?
                    <a href="#" class="register-link">Sign Up</a>
                </p>
            </div>
        </form>
    </div>
    <div class="form-box register">
        <h2 class="animation" style="--i:0;">Sign UP</h2>
        <p class="info-text animation" style="--i:1; color:#0ef;">Comming sooooooon</p>
        <div class="log-link animation" style="--i:2;">
            <p>
                Alrady have an account?
                <a href="#" class="login-link">Login</a>
            </p>
        </div>
    </div>

</div>

<script>
    var wrapper = document.querySelector(".wrapper");
    var registerLink = document.querySelector(".register-link");
    var loginLink = document.querySelector(".login-link");

    registerLink.onclick = () => {
        wrapper.classList.add('active');
    }

    loginLink.onclick = () => {
        wrapper.classList.remove('active');
    }
</script>