<?php

class dashboardModel extends DbModel
{
    function __construct()
    {
        parent::__construct();
    }

    function NewConsumarList()
    {
        $result = $this->db->table("tbl_consumer")
            ->select("tbl_consumer.*, tbl_agent.nickname AS agent_name, tbl_country.name AS country_name, tbl_country.currency_code, tbl_country.bdt_rate")
            ->join("tbl_agent", "tbl_agent.id", "=", "tbl_consumer.agent_id", "LEFT")
            ->join("tbl_country", "tbl_country.id", "=", "tbl_consumer.country_id", "LEFT")
            ->where([
                "is_submit" => 0,
                "result" => 0
            ])
            ->orderBy("tbl_consumer.agent_id, tbl_consumer.sl_no ASC")
            ->get();

        return $result;
    }

    function ReadyForAppointmentList()
    {
        $subQuery1 = "SELECT tbl_consumer.*, tbl_agent.nickname AS agent_name, tbl_country.name AS country_name, tbl_payment.card_id, tbl_payment.pay_amt, tbl_payment.currency, tbl_payment.conversion_rate, tbl_payment.total_bdt
        FROM tbl_consumer
        LEFT JOIN tbl_agent ON tbl_agent.id = tbl_consumer.agent_id
        LEFT JOIN tbl_payment ON tbl_payment.id = tbl_consumer.pay_id
        LEFT JOIN tbl_country ON tbl_country.id = tbl_consumer.country_id
        WHERE is_submit = 1 AND bio_appoint = 0 AND bio_done = 0";

        $subQuery2 = "SELECT tbl_consumer.*, tbl_agent.nickname AS agent_name, tbl_country.name AS country_name, tbl_payment.card_id, tbl_payment.pay_amt, tbl_payment.currency, tbl_payment.conversion_rate, tbl_payment.total_bdt
        FROM tbl_consumer
        LEFT JOIN tbl_agent ON tbl_agent.id = tbl_consumer.agent_id
        LEFT JOIN tbl_payment ON tbl_payment.id = tbl_consumer.pay_id
        LEFT JOIN tbl_country ON tbl_country.id = tbl_consumer.country_id
        WHERE is_submit = 1 AND result = 1 AND pass_sub_appoint = 0 AND pass_sub_done = 0";

        $result = $this->db->query("($subQuery1) UNION ALL ($subQuery2)");

        return $result;
    }


    function AppointmentBookedList()
    {
        $subQuery1 = "SELECT tbl_consumer.*, tbl_consumer.bio_date AS order_date, tbl_agent.nickname AS agent_name, tbl_country.name AS country_name, tbl_payment.card_id, tbl_payment.pay_amt, tbl_payment.currency, tbl_payment.conversion_rate, tbl_payment.total_bdt
            FROM tbl_consumer
            LEFT JOIN tbl_agent ON tbl_agent.id = tbl_consumer.agent_id
            LEFT JOIN tbl_payment ON tbl_payment.id = tbl_consumer.pay_id
            LEFT JOIN tbl_country ON tbl_country.id = tbl_consumer.country_id
            WHERE is_submit = 1 AND bio_appoint = 1 AND bio_done = 0
            ORDER BY tbl_consumer.bio_date ASC";

        $subQuery2 = "SELECT tbl_consumer.*, CASE WHEN result=1 THEN tbl_consumer.pass_sub_date ELSE tbl_consumer.bio_date END AS order_date, tbl_agent.nickname AS agent_name, tbl_country.name AS country_name, tbl_payment.card_id, tbl_payment.pay_amt, tbl_payment.currency, tbl_payment.conversion_rate, tbl_payment.total_bdt
            FROM tbl_consumer
            LEFT JOIN tbl_agent ON tbl_agent.id = tbl_consumer.agent_id
            LEFT JOIN tbl_payment ON tbl_payment.id = tbl_consumer.pay_id
            LEFT JOIN tbl_country ON tbl_country.id = tbl_consumer.country_id
            WHERE is_submit = 1 AND result = 1 AND pass_sub_appoint = 1 AND pass_sub_done = 0
            ORDER BY tbl_consumer.pass_sub_date ASC";

        $result = $this->db->query("($subQuery1) UNION ALL ($subQuery2) ORDER BY order_date ASC");

        return $result;
    }

    function WaitingResultList()
    {
        $result = $this->db->table("tbl_consumer")
            ->select("tbl_consumer.*, tbl_agent.nickname AS agent_name, tbl_country.name AS country_name, tbl_payment.card_id, tbl_payment.pay_amt, tbl_payment.currency, tbl_payment.conversion_rate, tbl_payment.total_bdt")
            ->join("tbl_agent", "tbl_agent.id", "=", "tbl_consumer.agent_id", "LEFT")
            ->join("tbl_payment", "tbl_payment.id", "=", "tbl_consumer.pay_id", "LEFT")
            ->join("tbl_country", "tbl_country.id", "=", "tbl_consumer.country_id", "LEFT")
            ->where([
                "is_submit" => 1,
                "bio_done" => 1,
                "result NOT IN" => [1, 2]
            ])
            ->orderBy("tbl_consumer.bio_date ASC")
            ->get();

        return $result;
    }

    function PassportSubmittedList()
    {
        $result = $this->db->table("tbl_consumer")
            ->select("tbl_consumer.*, tbl_agent.nickname AS agent_name, tbl_country.name AS country_name, tbl_payment.card_id, tbl_payment.pay_amt, tbl_payment.currency, tbl_payment.conversion_rate, tbl_payment.total_bdt")
            ->join("tbl_agent", "tbl_agent.id", "=", "tbl_consumer.agent_id", "LEFT")
            ->join("tbl_payment", "tbl_payment.id", "=", "tbl_consumer.pay_id", "LEFT")
            ->join("tbl_country", "tbl_country.id", "=", "tbl_consumer.country_id", "LEFT")
            ->where([
                "is_submit" => 1,
                "result" => 1,
                "pass_sub_done" => 1,
                "pass_collect NOT IN" => [1]
            ])
            ->orderBy("tbl_consumer.agent_id, tbl_consumer.sl_no ASC")
            ->get();

        return $result;
    }

    function ConsumerUpdate($id, $data)
    {
        return $this->db->table("tbl_consumer")->where(["id" => $id])->update($data);
    }

    function PaymentSubmission($data)
    {
        return $this->db->table("tbl_payment")->insert($data, true);
    }
}
