<?php

class sController
{
    protected $load;
    protected $model;
    private $childClassName;

    public function __construct($checkSession = true)
    {
        $this->load = new Load();
        $this->childClassName = get_called_class();

        if ($checkSession) {
            Session::CheckSession();
            $this->checkPermissions($this->childClassName);
        }

        Session::Set("pageTitle", strtoupper($this->childClassName) ."");

        $this->model = $this->load->Model($this->childClassName);
    }

    public function view($viewName, $data = NULL, $route="")
    {
        $this->load->View( $this->childClassName . '/' . $viewName, $data, $route);
    }

    public function viewModal($modalName, $data = NULL)
    {
        $this->load->ViewModal($this->childClassName . '/' . $modalName, $data);
    }

    protected function checkPermissions($childClassName)
    {
        $controllers = Permission();
        $desigCode = Session::Get("role");
        $childClassName = strtolower($childClassName);

        if (strlen($childClassName) == 0 || $desigCode === 1 || in_array($childClassName, $controllers[$desigCode])) {
            // Authorized access
        } else {
            // Handle unauthorized access
            die('Permission Denied'); // Or display an error message
        }
    }
}
