<?php

class Main
{
    private $url;
    private $controllerName = "dashboard";
    private $methodName = "index";
    private $controllerPath = "app/controllers/";
    private $controller;

    public function __construct()
    {
        $this->GetUrl();
        $this->LoadController();
        $this->CallMethod();
    }

    private function GetUrl()
    {
        $this->url = isset($_GET['url']) ? $_GET['url'] : NULL;

        if ($this->url != NULL) {
            $this->url = rtrim($this->url, '/');
            $this->url = explode('/', filter_var($this->url, FILTER_SANITIZE_URL));
        } else {
            unset($this->url);
        }
    }

    private function LoadController()
    {
        if (!isset($this->url[0])) {
            include $this->controllerPath . $this->controllerName . ".php";
            $this->controller = new $this->controllerName();
        } else {
            $this->controllerName = $this->url[0];
            $fileName = $this->controllerPath . $this->controllerName . ".php";
            if (file_exists($fileName)) {
                include $fileName;
                if (class_exists($this->controllerName)) {
                    $this->controller = new $this->controllerName();
                } else {
                    header("Location:../dashboard");
                }
            } else {
                header("Location:../dashboard");
            }
        }
    }

    private function CallMethod()
    {
        if (isset($this->url[2])) {
            $this->methodName = $this->url[1];
            if (method_exists($this->controller, $this->methodName)) {
                $this->controller->{$this->methodName}($this->url[2]);
            } else {
                header("Location:../dashboard");
            }
        } else {
            if (isset($this->url[1])) {
                $this->methodName = $this->url[1];
                if (method_exists($this->controller, $this->methodName)) {
                    $this->controller->{$this->methodName}();
                } else {
                    header("Location:../dashboard");
                }
            } else {
                if (method_exists($this->controller, $this->methodName)) {
                    $this->controller->{$this->methodName}();
                } else {
                    header("Location:../dashboard");
                }
            }
        }
    }
}
