<?php

class Database
{
    private $connection;

    public function __construct()
    {
        $host = 'localhost';
        $user = 'snapyquo_snapmome_azizul';
        $pass = 'e{{yz6VX,sB7';
        $db = 'snapyquo_snapmome_2016';
        

        // $host = 'localhost';
        // $user = 'shakikul_cmsv';
        // $pass = 'S08TI}pbstda';
        // $db = 'shakikul_cmsv_db';

        $this->connection = new mysqli($host, $user, $pass, $db);
        if ($this->connection->connect_error) {
            die("Connection failed: " . $this->connection->connect_error);
        }
    }

    public function table($table)
    {
        $queryBuilder = new QueryBuilder($this->connection, $table);
        return $queryBuilder;
    }

    public function query($query)
    {
        $stmt = $this->connection->prepare($query);
        $stmt->execute();
        $result = $stmt->get_result();
        return $result->fetch_all(MYSQLI_ASSOC);
    }
}

class QueryBuilder
{
    private $connection;
    private $table;
    private $select = "*";
    private $joins = array();
    private $where = array();
    private $groupBy = "";
    private $orderBy = "";
    private $limit = "";
    private $insertData = array();
    private $updateData = array();

    public function __construct($connection, $table)
    {
        $this->connection = $connection;
        $this->table = $table;
    }

    public function select($columns)
    {
        $this->select = is_array($columns) ? implode(", ", $columns) : $columns;
        return $this;
    }

    public function join($table, $columnA, $operator, $columnB, $type = 'INNER')
    {
        $this->joins[] = array(
            'type' => $type,
            'table' => $table,
            'columnA' => $columnA,
            'operator' => $operator,
            'columnB' => $columnB
        );
        return $this;
    }

    public function where($conditions)
    {
        $this->where = array_merge($this->where, $conditions);
        return $this;
    }

    public function groupBy($columns)
    {
        $this->groupBy = is_array($columns) ? implode(", ", $columns) : $columns;
        return $this;
    }

    public function orderBy($orderBy)
    {
        $this->orderBy = $orderBy;
        return $this;
    }

    public function limit($limit)
    {
        $this->limit = $limit;
        return $this;
    }

    public function insert($data, $returnInsertId = false)
    {
        $this->insertData[] = $data;
        return $this->insertExecute($returnInsertId);
    }

    public function update($data, $returnTrueFalse = true)
    {
        $this->updateData = array_merge($this->updateData, $data);
        return $this->updateExecute($returnTrueFalse);
    }

    public function delete()
    {
        $sql = "DELETE FROM $this->table";

        if (!empty($this->where)) {
            $sql .= " WHERE ";
            $conditionsArray = array();
            foreach ($this->where as $field => $value) {
                $conditionsArray[] = "$field = ?";
            }
            $sql .= implode(' AND ', $conditionsArray);
        }

        $stmt = $this->connection->prepare($sql);
        $params = array_values($this->where);
        $this->bindParams($stmt, $params);
        $stmt->execute();

        return $stmt->affected_rows;
    }

    public function get()
    {
        $sql = "SELECT $this->select FROM $this->table";
        $params = array();

        foreach ($this->joins as $join) {
            $sql .= " " . strtoupper($join['type']) . " JOIN " . $join['table'] . " ON " . $join['columnA'] . " " . $join['operator'] . " " . $join['columnB'];
        }

        if (!empty($this->where)) {
            $sql .= " WHERE";
            $logicOperator = "AND";
            $conditionsArray = array();

            foreach ($this->where as $field => $value) {

                if (is_array($value)) {
                    if (strpos($field, ' NOT IN') !== false) {
                        $field = str_replace(' NOT IN', '', $field);
                        $conditionsArray[] = " $field NOT IN (" . implode(', ', array_fill(0, count($value), '?')) . ")";
                        $params = array_merge($params, $value); // Merge array values into params
                    } else if (strpos($field, ' IN') !== false) {
                        $field = str_replace(' IN', '', $field);
                        $conditionsArray[] = " $field IN (" . implode(', ', array_fill(0, count($value), '?')) . ")";
                        $params = array_merge($params, $value); // Merge array values into params
                    } else if (strpos($field, ' BETWEEN') !== false) {
                        $field = str_replace(' BETWEEN', '', $field);
                        $conditionsArray[] = " ($field BETWEEN ? AND ?)";
                        $params[] = $value[0]; // Add lower bound value
                        $params[] = $value[1]; // Add upper bound value
                    } else if (strpos($field, ' LIKE') !== false) {
                        $field = str_replace(' LIKE', '', $field);
                        $conditionsArray[] = " $field LIKE ?";
                        $params = array_merge($params, $value);
                    }
                } else {
                    if (preg_match('/\s*(<=|>=|<|>|=|!=)\s*/', $field, $matches)) {
                        // If the field has an operator like <=, >=, <, >, =, or !=
                        $operator = $matches[1]; // Capture the operator
                        $field = str_replace($operator, '', $field);  // Remove operator from field name
                        $conditionsArray[] = " $field $operator ?";  // Add the condition with the operator
                        $params[] = $value;  // Bind the parameter
                    } else {
                        // Default equality condition (no operator, just `=`)
                        $conditionsArray[] = " $field = ?";
                        $params[] = $value;
                    }
                }
            }
            $sql .= implode(" $logicOperator ", $conditionsArray);
        }

        if (!empty($this->groupBy)) {
            $sql .= " GROUP BY $this->groupBy";
        }

        if (!empty($this->orderBy)) {
            $sql .= " ORDER BY $this->orderBy";
        }

        if (!empty($this->limit)) {
            $sql .= " LIMIT $this->limit";
        }

        $stmt = $this->connection->prepare($sql);
        $this->bindParams($stmt, $params);
        $stmt->execute();

        $result = $stmt->get_result();
        return $result->fetch_all(MYSQLI_ASSOC);
    }





    private function insertExecute($returnInsertId)
    {
        $fields = implode(",", array_keys($this->insertData[0]));
        $placeholders = implode(",", array_fill(0, count($this->insertData[0]), "?"));
        $values = array_values($this->insertData[0]);

        $sql = "INSERT INTO $this->table ($fields) VALUES ($placeholders)";
        $stmt = $this->connection->prepare($sql);
        $this->bindParams($stmt, $values);
        $success = $stmt->execute();

        if ($returnInsertId) {
            return $stmt->insert_id;
        } else {
            return $success > 0 ? true : false;
        }
    }

    private function updateExecute($returnTrueFalse)
    {
        $sql = "UPDATE $this->table SET ";
        $updateArray = array();
        foreach ($this->updateData as $field => $value) {
            $updateArray[] = "$field = ?";
        }
        $sql .= implode(", ", $updateArray);

        if (!empty($this->where)) {
            $sql .= " WHERE ";
            $conditionsArray = array();
            foreach ($this->where as $field => $value) {
                $conditionsArray[] = "$field = ?";
            }
            $sql .= implode(' AND ', $conditionsArray);
        }

        $stmt = $this->connection->prepare($sql);
        $params = array_merge(array_values($this->updateData), array_values($this->where));
        $this->bindParams($stmt, $params);
        $stmt->execute();

        if ($returnTrueFalse) {
            return $stmt->affected_rows > 0 ? true : false;
        } else {
            return $stmt->affected_rows;
        }
    }

    public function exist()
    {
        $sql = "SELECT 1 FROM $this->table";

        if (!empty($this->where)) {
            $sql .= " WHERE ";
            $conditionsArray = array();
            foreach ($this->where as $field => $value) {
                $conditionsArray[] = "$field= ?";
            }
            $sql .= implode(' AND ', $conditionsArray);
        }

        if (!empty($this->limit)) {
            $sql .= " LIMIT $this->limit";
        }

        $stmt = $this->connection->prepare($sql);
        $this->bindParams($stmt, array_values($this->where));
        $stmt->execute();
        $stmt->store_result();

        return $stmt->num_rows > 0;
    }

    private function bindParams($stmt, $params)
    {
        if (!empty($params)) {
            $types = str_repeat('s', count($params));
            $stmt->bind_param($types, ...$params);
        }
    }
}
