<?php

class login extends sController
{
    public function __construct()
    {
        parent::__construct(false);
    }

    public function index()
    {
        $this->login();
    }

    public function login()
    {
        Session::Init();
        if (Session::Get("login") == true) {
            header("Location:../dashboard");
            exit;
        }

        $this->load->View("login");
    }

    public function authentication()
    {
        $userName = $_POST["userName"];
        $pass = $_POST["password"];

        $user = $this->model->GetByUserName($userName);

        if (password_verify($pass, $user[0]['password'])) {

            $empImg = EMP_PHOTO_URL . $user[0]["username"] . IMAGE_EXTENSION;

            if (!file_exists($empImg) || $empImg === null) {
                $empImg = EMP_DEFAULT_PHOTO_URL;
            }

            Session::Init();
            Session::Set("username", $user[0]["username"]);
            Session::Set("fullname", strtoupper($user[0]["full_name"]));
            Session::Set("role", $user[0]["role"]);
            Session::Set("userRole", $user[0]["user_role"]);
            Session::Set("designation", $user[0]["designation"]);
            Session::Set("empImg", $empImg);
            Session::Set("login", true);
            Session::Set("pageTitle", "");
            header("Location:../dashboard");
            exit;
        } else {
            header("Location:../login");
            exit;
        }
    }

    public function logout()
    {
        Session::Init();
        Session::Destroy();
        header("Location:../login");
        exit;
    }
}
